/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.request;

import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.common.Log;
import com.xdja.svs.protocol.IRequest;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class MultiEncryptDataFinalRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer symKeyID;
    private ASN1OctetString plaintext;
    private ASN1OctetString iv;

    public MultiEncryptDataFinalRequest(long symKeyID, byte[] plaintext, ASN1OctetString iv) {
        this.symKeyID = new ASN1Integer(symKeyID);
        this.plaintext = plaintext != null ? new DEROctetString(plaintext) : new DEROctetString(new byte[0]);
        this.iv = iv;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.symKeyID);
        vector.add(new DERTaggedObject(false, 0, this.plaintext));
        if (this.iv != null && this.iv.getOctets().length > 0) {
            vector.add(new DERTaggedObject(false, 1, this.iv));
        } else {
            Log.print("-------------------construct data final req ,iv is :" + this.iv);
        }
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.ENCRYPT_DATA_REQ_FINAL;
    }
}

