/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.request;

import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import com.xdja.svs.utils.CertUtils;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class MultiEncryptDataInitRequest
extends ASN1Object
implements IRequest {
    private SubjectPublicKeyInfo encPubkey;
    private ASN1Integer pubkeyType;
    private ASN1Integer symAlgo;
    private ASN1Integer paddingType;

    public MultiEncryptDataInitRequest(PublicKey encPubkey, long symAlgo) {
        this.paddingType = new ASN1Integer(0L);
        this.pubkeyType = CertUtils.isRsa(encPubkey) ? new ASN1Integer(1L) : (CertUtils.isSm2(encPubkey) ? new ASN1Integer(0L) : new ASN1Integer(2L));
        this.encPubkey = SubjectPublicKeyInfo.getInstance(encPubkey.getEncoded());
        this.symAlgo = new ASN1Integer(symAlgo);
    }

    public MultiEncryptDataInitRequest(SubjectPublicKeyInfo encPubkey, long pubkeyType, long symAlgo) {
        this.encPubkey = encPubkey;
        this.pubkeyType = new ASN1Integer(pubkeyType);
        this.symAlgo = new ASN1Integer(symAlgo);
        this.paddingType = new ASN1Integer(0L);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.encPubkey);
        vector.add(this.pubkeyType);
        vector.add(this.symAlgo);
        vector.add(this.paddingType);
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.ENCRYPT_DATA_REQ_INIT;
    }
}

