/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.request;

import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.common.Log;
import com.xdja.svs.protocol.IRequest;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class MultiEncryptDataUpdateRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer symKeyID;
    private ASN1OctetString plaintext;
    private ASN1OctetString iv;

    public MultiEncryptDataUpdateRequest(long symKeyID, byte[] plaintext, ASN1OctetString iv) {
        this.symKeyID = new ASN1Integer(symKeyID);
        this.plaintext = new DEROctetString(plaintext);
        this.iv = iv;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.symKeyID);
        vector.add(this.plaintext);
        if (this.iv == null || this.iv.getOctets().length <= 0) {
            Log.print("no wrapper iv field");
        } else {
            vector.add(this.iv);
        }
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.ENCRYPT_DATA_REQ_UPDATE;
    }
}

