/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.request;

import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SingleDecryptDataRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer keyIndex;
    private ASN1OctetString passWord;
    private ASN1Integer symAlgo;
    private ASN1OctetString symKey;
    private ASN1OctetString cipherText;
    private ASN1OctetString iv;
    private ASN1Integer paddingType;

    public SingleDecryptDataRequest(Integer keyIndex, String passWord, long encAlg, ASN1OctetString symKey, ASN1OctetString cipherText, ASN1OctetString iv) {
        this.keyIndex = new ASN1Integer(keyIndex.intValue());
        this.passWord = new DEROctetString(passWord.getBytes());
        this.symAlgo = new ASN1Integer(encAlg);
        this.symKey = symKey;
        this.cipherText = cipherText;
        this.paddingType = new ASN1Integer(0L);
        String realIv = "1234567812345678";
        this.iv = new DEROctetString(realIv.getBytes());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.keyIndex);
        vector.add(this.passWord);
        vector.add(this.symAlgo);
        vector.add(this.symKey);
        vector.add(this.cipherText);
        vector.add(this.paddingType);
        if (this.iv != null) {
            vector.add(this.iv);
        }
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.SINGLE_DECRYPT_DATA_REQ;
    }
}

