/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.request;

import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class SingleEncryptDataRequest
extends ASN1Object
implements IRequest {
    private SubjectPublicKeyInfo encPubkey;
    private ASN1Integer pubkeyType;
    private ASN1Integer symAlgo;
    private ASN1OctetString data;
    private ASN1Integer paddingType;
    private ASN1OctetString iv;

    public SingleEncryptDataRequest(SubjectPublicKeyInfo encPubkey, long pubkeyType, long symAlgo, byte[] data, byte[] iv) {
        this.encPubkey = encPubkey;
        this.pubkeyType = new ASN1Integer(pubkeyType);
        this.symAlgo = new ASN1Integer(symAlgo);
        this.data = new DEROctetString(data);
        this.paddingType = new ASN1Integer(0L);
        this.iv = new DEROctetString(iv);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.encPubkey);
        vector.add(this.pubkeyType);
        vector.add(this.symAlgo);
        vector.add(this.data);
        vector.add(this.paddingType);
        vector.add(this.iv);
        DERSequence derSequence = new DERSequence(vector);
        return derSequence;
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.SINGLE_ENCRYPT_DATA_REQ;
    }
}

