/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.response;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;

public class MultiDecryptDataUpdateResponse {
    private ASN1Integer respValue;
    private ASN1OctetString plaintext;
    private ASN1OctetString iv;

    public MultiDecryptDataUpdateResponse(ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance(derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            ASN1Encodable[] items = asn1Sequence.toArray();
            this.respValue = ASN1Integer.getInstance(items[0]);
            if (this.isSuccess()) {
                ASN1TaggedObject plaintextTag = DERTaggedObject.getInstance(items[1]);
                this.plaintext = ASN1OctetString.getInstance(plaintextTag.getObjectParser(plaintextTag.getTagNo(), true));
                if (items.length == 3) {
                    ASN1TaggedObject ivTagObject = DERTaggedObject.getInstance(items[2]);
                    ASN1Encodable iv = ivTagObject.getObjectParser(ivTagObject.getTagNo(), true);
                    this.iv = DEROctetString.getInstance(iv);
                }
            }
        }
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public ASN1OctetString getPlaintext() {
        return this.plaintext;
    }

    public ASN1OctetString getIv() {
        return this.iv;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

