/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.response;

import com.xdja.svs.common.Log;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERTaggedObject;

public class MultiEncryptDataFinalResponse {
    private ASN1Integer respValue;
    private ASN1OctetString cipherText;
    private ASN1OctetString iv;

    public MultiEncryptDataFinalResponse(ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance(derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            ASN1Encodable[] items = asn1Sequence.toArray();
            this.respValue = ASN1Integer.getInstance(items[0]);
            if (this.isSuccess()) {
                ASN1TaggedObject cipherTextTag = DERTaggedObject.getInstance(items[1]);
                this.cipherText = ASN1OctetString.getInstance(cipherTextTag.getObjectParser(cipherTextTag.getTagNo(), true));
                if (items.length == 3) {
                    ASN1TaggedObject ivTag = DERTaggedObject.getInstance(items[2]);
                    this.iv = ASN1OctetString.getInstance(ivTag.getObjectParser(ivTag.getTagNo(), true));
                }
            } else {
                Log.print("----MultiEncryptData-Final---- code is not  zero--------");
            }
        }
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public ASN1OctetString getCipherText() {
        return this.cipherText;
    }

    public ASN1OctetString getIv() {
        return this.iv;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

