/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.response;

import com.xdja.svs.common.Log;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.encoders.Hex;

public class MultiEncryptDataInitResponse
extends ASN1Object {
    private ASN1Integer respValue;
    private ASN1OctetString symKey;
    private ASN1Integer symKeyID;
    private ASN1OctetString iv;

    public MultiEncryptDataInitResponse(ASN1Encodable instance) throws IOException {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance(derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            ASN1Encodable[] items = asn1Sequence.toArray();
            this.respValue = ASN1Integer.getInstance(items[0]);
            if (this.isSuccess()) {
                ASN1TaggedObject symKeyTag = DERTaggedObject.getInstance(items[1]);
                this.symKey = ASN1OctetString.getInstance(symKeyTag.getObjectParser(symKeyTag.getTagNo(), true));
                ASN1TaggedObject symKeyIDObject = DERTaggedObject.getInstance(items[2]);
                ASN1Encodable symKeyIDEnc = symKeyIDObject.getObjectParser(symKeyIDObject.getTagNo(), true);
                String hexSymKeyId = Hex.toHexString(ASN1OctetString.getInstance(symKeyIDEnc).getOctets());
                int symKeyId = Integer.parseInt(hexSymKeyId, 16);
                this.symKeyID = new ASN1Integer(symKeyId);
                if (items.length == 4) {
                    ASN1TaggedObject ivTagObject = DERTaggedObject.getInstance(items[3]);
                    ASN1Encodable iv = ivTagObject.getObjectParser(ivTagObject.getTagNo(), true);
                    this.iv = DEROctetString.getInstance(iv);
                }
            } else {
                Log.print("----MultiEncryptDataInit---- code is not  zero--------");
            }
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.respValue);
        vector.add(this.symKey);
        vector.add(this.symKeyID);
        vector.add(this.iv);
        return new DERSequence(vector);
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public ASN1OctetString getSymKey() {
        return this.symKey;
    }

    public ASN1OctetString getIv() {
        return this.iv;
    }

    public ASN1Integer getSymKeyID() {
        return this.symKeyID;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

