/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.response;

import com.xdja.svs.alg.EncAlg;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class MultiEncryptDataUpdateResponse
extends ASN1Object {
    private ASN1Integer respValue;
    private ASN1OctetString ciphertext;
    private ASN1OctetString iv;

    public MultiEncryptDataUpdateResponse(int encryptMode, ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance(derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance(asn1Sequence.getObjectAt(0));
            if (this.isSuccess()) {
                DERTaggedObject cipherObject = (DERTaggedObject)asn1Sequence.getObjectAt(1);
                this.ciphertext = DEROctetString.getInstance(cipherObject.getObject());
                if (EncAlg.wrapIv(encryptMode)) {
                    DERTaggedObject ivObject = (DERTaggedObject)asn1Sequence.getObjectAt(2);
                    this.iv = DEROctetString.getInstance(ivObject.getObject());
                }
            }
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.respValue);
        vector.add(this.ciphertext);
        vector.add(this.iv);
        return new DERSequence(vector);
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public ASN1OctetString getCipherText() {
        return this.ciphertext;
    }

    public ASN1OctetString getIv() {
        return this.iv;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

