/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.response;

import com.xdja.svs.alg.EncAlg;
import com.xdja.svs.common.Log;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;

public class SingleEncryptDataResponse {
    private ASN1Integer respValue;
    private ASN1OctetString cipherText;
    private ASN1OctetString symKey;
    private ASN1OctetString iv;

    public SingleEncryptDataResponse(int encryptAlg, ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance(derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance(asn1Sequence.getObjectAt(0));
            if (this.isSuccess()) {
                DERTaggedObject cipherObject = (DERTaggedObject)asn1Sequence.getObjectAt(1);
                this.cipherText = DEROctetString.getInstance(cipherObject.getObject());
                DERTaggedObject symKeyObject = (DERTaggedObject)asn1Sequence.getObjectAt(2);
                this.symKey = DEROctetString.getInstance(symKeyObject.getObject());
                if (EncAlg.wrapIv(encryptAlg)) {
                    DERTaggedObject ivObject = (DERTaggedObject)asn1Sequence.getObjectAt(3);
                    this.iv = DEROctetString.getInstance(ivObject.getObject());
                }
            } else {
                Log.print("single encrypt data resp error");
            }
        }
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public ASN1OctetString getCipherText() {
        return this.cipherText;
    }

    public ASN1OctetString getSymKey() {
        return this.symKey;
    }

    public ASN1OctetString getIv() {
        return this.iv;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

