/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.hash.request;

import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class HashInitRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer hashAlg;
    private SubjectPublicKeyInfo signerPublicKey;
    private ASN1OctetString signerID;

    public HashInitRequest(long hashAlg, SubjectPublicKeyInfo signerPublicKey, String signerID) {
        this.hashAlg = new ASN1Integer(hashAlg);
        this.signerPublicKey = signerPublicKey;
        this.signerID = new DEROctetString(signerID.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.hashAlg);
        vector.add(new DERTaggedObject(false, 0, this.signerPublicKey));
        vector.add(new DERTaggedObject(false, 1, this.signerID));
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.HASH_INIT_REQ;
    }
}

