/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.hash.response;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class HashInitResponse
extends ASN1Object {
    private ASN1Integer respValue;
    private ASN1Integer hashId;

    public HashInitResponse(ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance(derTaggedObject.getObjectParser(0, true));
            this.hashId = ASN1Integer.getInstance(derTaggedObject.getObjectParser(1, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance(asn1Sequence.getObjectAt(0));
            this.hashId = ASN1Integer.getInstance(asn1Sequence.getObjectAt(1));
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.respValue);
        vector.add(this.hashId);
        return new DERSequence(vector);
    }

    public ASN1Integer getHashId() {
        return this.hashId;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

