/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.response;

import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AppContext
extends ASN1Object {
    private ASN1Integer keyIndex;
    private X509Certificate signCert;
    private X500Name signIssuer;
    private ASN1Integer signSerial;
    private X509Certificate encCert;
    private X500Name encIssuer;
    private ASN1Integer encSerial;

    public AppContext(ASN1Sequence instance) throws Exception {
        this.keyIndex = ASN1Integer.getInstance(instance.getObjectAt(0));
        byte[] signEncoded = instance.getObjectAt(1).toASN1Primitive().getEncoded();
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        ByteArrayInputStream inStream_sign = new ByteArrayInputStream(signEncoded);
        this.signCert = (X509Certificate)cf.generateCertificate(inStream_sign);
        this.signIssuer = X500Name.getInstance(instance.getObjectAt(2));
        this.signSerial = ASN1Integer.getInstance(instance.getObjectAt(3));
        if (instance.size() > 5) {
            ASN1TaggedObject encTagObject = DERTaggedObject.getInstance(instance.getObjectAt(4));
            ASN1Sequence encSequence = ASN1Sequence.getInstance(encTagObject, true);
            ByteArrayInputStream inStream_enc = new ByteArrayInputStream(encSequence.toASN1Primitive().getEncoded());
            this.encCert = (X509Certificate)cf.generateCertificate(inStream_enc);
            ASN1TaggedObject x500NameTagObject = DERTaggedObject.getInstance(instance.getObjectAt(5));
            this.encIssuer = X500Name.getInstance(x500NameTagObject, true);
            ASN1TaggedObject encSerialTagObject = DERTaggedObject.getInstance(instance.getObjectAt(6));
            this.encSerial = ASN1Integer.getInstance(encSerialTagObject, true);
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.keyIndex);
        vector.add(this.signIssuer);
        vector.add(this.signSerial);
        vector.add(this.encIssuer);
        vector.add(this.encSerial);
        return new DERSequence(vector);
    }

    public ASN1Integer getKeyIndex() {
        return this.keyIndex;
    }

    public void setKeyIndex(ASN1Integer keyIndex) {
        this.keyIndex = keyIndex;
    }

    public X500Name getSignIssuer() {
        return this.signIssuer;
    }

    public void setSignIssuer(X500Name signIssuer) {
        this.signIssuer = signIssuer;
    }

    public ASN1Integer getSignSerial() {
        return this.signSerial;
    }

    public void setSignSerial(ASN1Integer signSerial) {
        this.signSerial = signSerial;
    }

    public X500Name getEncIssuer() {
        return this.encIssuer;
    }

    public void setEncIssuer(X500Name encIssuer) {
        this.encIssuer = encIssuer;
    }

    public ASN1Integer getEncSerial() {
        return this.encSerial;
    }

    public void setEncSerial(ASN1Integer encSerial) {
        this.encSerial = encSerial;
    }

    public X509Certificate getSignCert() {
        return this.signCert;
    }

    public void setSignCert(X509Certificate signCert) {
        this.signCert = signCert;
    }

    public X509Certificate getEncCert() {
        return this.encCert;
    }

    public void setEncCert(X509Certificate encCert) {
        this.encCert = encCert;
    }

    public String toString() {
        return "GMT0029_RelateAppContext{keyIndex=" + this.keyIndex.toString() + ", signIssuer=" + this.signIssuer.toString() + ", signSerial=" + this.signSerial.toString() + ", encIssuer=" + this.encIssuer.toString() + ", encSerial=" + this.encSerial.toString() + '}';
    }

    static {
        try {
            Security.addProvider(new BouncyCastleProvider());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

