/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.signdata.request;

import com.xdja.svs.Session;
import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.protocol.IRequest;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class SignDataInitRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer signMethod;
    private ASN1OctetString signerPublicKey;
    private ASN1Integer signerIDLen;
    private ASN1OctetString signerID;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;

    public SignDataInitRequest(Session session, byte[] inData) throws SOR_ParameterNotSupportedException {
        this.signMethod = new ASN1Integer(session.getSignAlg());
        this.inData = new DEROctetString(inData);
        this.inDataLen = new ASN1Integer(inData.length);
        String signId = session.getSignID();
        this.signerID = new DEROctetString(signId.getBytes(StandardCharsets.UTF_8));
        this.signerIDLen = new ASN1Integer(signId.length());
        this.signerPublicKey = new DEROctetString(session.getSignCert().getPublicKey().getEncoded());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.signMethod);
        vector.add(new DERTaggedObject(false, 0, this.signerPublicKey));
        vector.add(new DERTaggedObject(false, 1, this.signerIDLen));
        vector.add(new DERTaggedObject(false, 2, this.signerID));
        vector.add(this.inDataLen);
        vector.add(this.inData);
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.SIGN_DATA_INIT;
    }
}

