/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.signdata.request;

import com.xdja.svs.Session;
import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SingleSignDataRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer signMethod;
    private ASN1Integer keyIndex;
    private ASN1OctetString keyValue;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;

    public SingleSignDataRequest(long signMethod, int keyIndex, String keyValue, byte[] indata) {
        this.signMethod = new ASN1Integer(signMethod);
        this.keyIndex = new ASN1Integer(keyIndex);
        this.keyValue = new DEROctetString(keyValue.getBytes(StandardCharsets.UTF_8));
        this.inDataLen = new ASN1Integer(indata.length);
        this.inData = new DEROctetString(indata);
    }

    public SingleSignDataRequest(Session session, byte[] originData) {
        this.signMethod = new ASN1Integer(session.getSignAlg());
        this.keyIndex = new ASN1Integer(session.getPrivateKeyIndex());
        this.keyValue = new DEROctetString(session.getPrivateKeyPwd().getBytes(StandardCharsets.UTF_8));
        this.inData = new DEROctetString(originData);
        this.inDataLen = new ASN1Integer(originData.length);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.signMethod);
        vector.add(this.keyIndex);
        vector.add(this.keyValue);
        vector.add(this.inDataLen);
        vector.add(this.inData);
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.SIGN_DATA;
    }
}

