/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.signdata.request;

import com.xdja.svs.Session;
import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class VerifySignDataFinalRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer signMethod;
    private ASN1Integer type;
    private X509Certificate cert;
    private ASN1OctetString certSN;
    private ASN1Integer hashValueLen;
    private ASN1OctetString hashValue;
    private ASN1OctetString signature;
    private ASN1Integer verifyLevel;

    public VerifySignDataFinalRequest(Session session, X509Certificate cert, byte[] hashValue, byte[] signature) {
        this.signMethod = new ASN1Integer(session.getSignAlg());
        this.type = new ASN1Integer(session.getVerifyType());
        this.cert = cert;
        String serialNo = cert.getSerialNumber().toString(16);
        this.certSN = new DEROctetString(serialNo.getBytes(StandardCharsets.UTF_8));
        this.hashValue = new DEROctetString(hashValue);
        this.hashValueLen = new ASN1Integer(hashValue.length);
        this.signature = new DEROctetString(signature);
        this.verifyLevel = new ASN1Integer(session.getVerifyLevel());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.signMethod);
        vector.add(new DERTaggedObject(false, 0, this.type));
        try {
            vector.add(new DERTaggedObject(false, 1, ASN1Primitive.fromByteArray(this.cert.getEncoded())));
        }
        catch (IOException iOException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        vector.add(this.certSN);
        vector.add(this.hashValueLen);
        vector.add(this.hashValue);
        vector.add(this.signature);
        vector.add(this.verifyLevel);
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.VERIFY_SIGNED_DATA_FINAL;
    }
}

