/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.signdata.request;

import com.xdja.svs.Session;
import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class VerifySignDataInitRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer signMethod;
    private ASN1OctetString signerPublicKey;
    private ASN1Integer signerIDLen;
    private ASN1OctetString signerID;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;

    public VerifySignDataInitRequest(Session sofInstance, X509Certificate certificate, byte[] inData) {
        this.signMethod = new ASN1Integer(sofInstance.getSignAlg());
        this.inData = new DEROctetString(inData);
        this.inDataLen = new ASN1Integer(inData.length);
        this.signerPublicKey = new DEROctetString(certificate.getPublicKey().getEncoded());
        this.signerIDLen = new ASN1Integer(sofInstance.getSignID().length());
        this.signerID = new DEROctetString(sofInstance.getSignID().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.signMethod);
        vector.add(new DERTaggedObject(false, 0, this.signerPublicKey));
        vector.add(new DERTaggedObject(false, 1, this.signerIDLen));
        vector.add(new DERTaggedObject(false, 2, this.signerID));
        vector.add(this.inDataLen);
        vector.add(this.inData);
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.VERIFY_SIGNED_DATA_INIT;
    }
}

