/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.signdata.request;

import com.xdja.svs.Session;
import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class VerifySignDataUpdateRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer signMethod;
    private ASN1Integer hashValueLen;
    private ASN1OctetString hashValue;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;

    public VerifySignDataUpdateRequest(Session session, byte[] hashValue, byte[] inData) {
        this.signMethod = new ASN1Integer(session.getSignAlg());
        this.hashValue = new DEROctetString(hashValue);
        this.hashValueLen = new ASN1Integer(hashValue.length);
        this.inData = new DEROctetString(inData);
        this.inDataLen = new ASN1Integer(inData.length);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.signMethod);
        vector.add(this.hashValueLen);
        vector.add(this.hashValue);
        vector.add(this.inDataLen);
        vector.add(this.inData);
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.VERIFY_SIGNED_DATA_UPDATE;
    }
}

