/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.signdata.request;

import com.xdja.svs.Session;
import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class VerifySignedDataRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer type;
    private X509Certificate cert;
    private ASN1OctetString certSN;
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;
    private ASN1OctetString signature;
    private ASN1Integer verifyLevel;

    public VerifySignedDataRequest(Session session, X509Certificate cert, byte[] inData, byte[] signature) {
        this.type = new ASN1Integer(session.getVerifyType());
        this.cert = cert;
        String certSN = cert.getSerialNumber().toString(16);
        this.certSN = new DEROctetString(certSN.getBytes(StandardCharsets.UTF_8));
        this.inDataLen = new ASN1Integer(inData.length);
        this.inData = new DEROctetString(inData);
        this.signature = new DEROctetString(signature);
        this.verifyLevel = new ASN1Integer(session.getVerifyLevel());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.type);
        try {
            vector.add(new DERTaggedObject(false, 0, ASN1Primitive.fromByteArray(this.cert.getEncoded())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        vector.add(new DERTaggedObject(false, 1, this.certSN));
        vector.add(this.inDataLen);
        vector.add(this.inData);
        vector.add(this.signature);
        vector.add(this.verifyLevel);
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.VERIFY_SIGNED_DATA;
    }
}

