/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.signmsg.request;

import com.xdja.svs.Session;
import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SignMessageFinalRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer signMethod;
    private ASN1Integer keyIndex;
    private ASN1OctetString keyValue;
    private ASN1Integer hashValueLen;
    private ASN1OctetString hashValue;

    public SignMessageFinalRequest(Session session, byte[] hashValue) {
        this.signMethod = new ASN1Integer(session.getSignAlg());
        this.keyIndex = new ASN1Integer(session.getPrivateKeyIndex());
        String keyValue = session.getPrivateKeyPwd();
        this.keyValue = new DEROctetString(keyValue.getBytes(StandardCharsets.UTF_8));
        this.hashValue = new DEROctetString(hashValue);
        this.hashValueLen = new ASN1Integer(hashValue.length);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.signMethod);
        vector.add(this.keyIndex);
        vector.add(this.keyValue);
        vector.add(this.hashValueLen);
        vector.add(this.hashValue);
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.SIGN_MESSAGE_FINAL;
    }
}

