/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.signmsg.request;

import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class VerifySignedMessageRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer inDataLen;
    private ASN1OctetString inData;
    private ASN1OctetString signedMessage;
    private ASN1Boolean hashFlag;
    private ASN1Boolean originalText;
    private ASN1Boolean certificateChain;
    private ASN1Boolean crl;
    private ASN1Boolean authenticationAttributes;

    public VerifySignedMessageRequest(int inDataLen, byte[] inData, byte[] signedMessage, Boolean hashFlag, Boolean originalText, Boolean certificateChain, Boolean crl, Boolean authenticationAttributes) {
        this.inDataLen = new ASN1Integer(inDataLen);
        this.inData = new DEROctetString(inData);
        this.signedMessage = new DEROctetString(signedMessage);
        this.hashFlag = ASN1Boolean.getInstance(hashFlag);
        this.originalText = ASN1Boolean.getInstance(originalText);
        this.certificateChain = ASN1Boolean.getInstance(certificateChain);
        this.crl = ASN1Boolean.getInstance(crl);
        this.authenticationAttributes = ASN1Boolean.getInstance(authenticationAttributes);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.inDataLen);
        vector.add(this.inData);
        vector.add(this.signedMessage);
        vector.add(this.hashFlag);
        vector.add(new DERTaggedObject(false, 0, this.originalText));
        vector.add(new DERTaggedObject(false, 1, this.certificateChain));
        vector.add(new DERTaggedObject(false, 2, this.crl));
        vector.add(new DERTaggedObject(false, 3, this.authenticationAttributes));
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.VERIFY_SIGNED_MESSAGE;
    }
}

