/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.timestamp;

import com.xdja.svs.Session;
import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.protocol.IRequest;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class CreateTimeStampRespRequest
extends ASN1Object
implements IRequest {
    private ASN1OctetString tsReq;
    private ASN1Integer signAlg;
    private ASN1Integer keyIndex;
    private ASN1Integer keyBits;
    private ASN1OctetString keyValue;

    public CreateTimeStampRespRequest(byte[] tsReq, Session session) throws SOR_ParameterNotSupportedException {
        this.tsReq = new DEROctetString(tsReq);
        this.keyBits = new ASN1Integer(session.getKeyBits());
        this.signAlg = new ASN1Integer(session.getSignAlg());
        this.keyIndex = new ASN1Integer(session.getPrivateKeyIndex());
        this.keyValue = new DEROctetString(session.getPrivateKeyPwd().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.tsReq);
        vector.add(this.signAlg);
        vector.add(this.keyIndex);
        vector.add(this.keyBits);
        vector.add(this.keyValue);
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.CREATE_TIMESTAMP_RESP_REQ;
    }
}

