/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.timestamp;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class ParseTimeStampResponse
extends ASN1Object {
    private ASN1Integer respValue;
    private ASN1OctetString data;

    public ParseTimeStampResponse(ASN1Sequence sequence) {
        ASN1Encodable asn1Encodable = sequence.getObjectAt(2);
        DERTaggedObject derTaggedObject = (DERTaggedObject)asn1Encodable.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            try {
                this.respValue = ASN1Integer.getInstance(derTaggedObject.getObjectParser(0, true));
            }
            catch (IOException e) {
                return;
            }
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance(asn1Sequence.getObjectAt(0));
            this.data = DEROctetString.getInstance(asn1Sequence.getObjectAt(1));
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.respValue);
        vector.add(this.data);
        return new DERSequence(vector);
    }

    public ASN1Integer getRespValue() {
        return this.respValue;
    }

    public void setRespValue(ASN1Integer respValue) {
        this.respValue = respValue;
    }

    public ASN1OctetString getData() {
        return this.data;
    }

    public void setData(ASN1OctetString data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

