/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.timestamp;

import com.xdja.svs.Session;
import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.protocol.IRequest;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class VerifyTimeStampRequest
extends ASN1Object
implements IRequest {
    private ASN1OctetString tsResp;
    private ASN1Integer signAlg;
    private ASN1Integer verifyLevel;
    private X509Certificate cert;

    public VerifyTimeStampRequest(byte[] tsResp, Session session, boolean attachCert) throws SOR_ParameterNotSupportedException {
        this.tsResp = new DEROctetString(tsResp);
        this.signAlg = new ASN1Integer(session.getSignAlg());
        this.verifyLevel = new ASN1Integer(session.getVerifyLevel());
        if (attachCert) {
            this.cert = session.getSignCert();
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.tsResp);
        vector.add(this.signAlg);
        vector.add(this.verifyLevel);
        try {
            if (this.cert != null) {
                vector.add(ASN1Primitive.fromByteArray(this.cert.getEncoded()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.VERIFY_TIMESTAMP_REQ;
    }
}

