/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.socket;

import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.IRequest;
import com.xdja.svs.protocol.SvsRequest;
import com.xdja.svs.socket.Tlv;
import com.xdja.svs.socket.TlvDataBody;
import com.xdja.svs.socket.TlvTools;
import com.xdja.svs.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Sequence;

public class SocketFactory {
    private Socket socket;

    public SocketFactory(String hostName, Integer port, Integer readTimeOut, Integer connectTimeOut) throws IOException {
        this.socket = this.getSocketConnection(hostName, port, readTimeOut, connectTimeOut);
    }

    private Socket getSocketConnection(String hostName, Integer port, Integer readTimeOut, Integer connectTimeOut) throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(readTimeOut * 1000);
        socket.setReuseAddress(true);
        socket.setKeepAlive(true);
        socket.setReceiveBufferSize(0x4000000);
        socket.setSendBufferSize(0x4000000);
        try {
            socket.connect(new InetSocketAddress(hostName, (int)port), connectTimeOut);
        }
        catch (Exception e) {
            throw new SocketException("socket connection exception:" + e.getMessage());
        }
        return socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void releaseSocketResource() throws IOException {
        if (this.socket != null && !this.socket.isClosed()) {
            FileUtils.close(this.socket.getInputStream());
            FileUtils.close(this.socket);
        }
    }

    private int write(Socket socket, byte[] requestBody) {
        try {
            BufferedOutputStream writer = new BufferedOutputStream(socket.getOutputStream());
            writer.write(requestBody);
            writer.flush();
            return 0;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private TlvDataBody read(Socket socket) throws ServiceException {
        TlvTools tlvTools = new TlvTools();
        try {
            int bufferLen;
            BufferedInputStream reader = new BufferedInputStream(socket.getInputStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] bufferByte = new byte[8192];
            boolean loop = true;
            int exceptLength = 0;
            ArrayList<Tlv> tlvList = new ArrayList<Tlv>();
            while ((bufferLen = reader.read(bufferByte)) != -1) {
                out.write(bufferByte, 0, bufferLen);
                int readLength = out.toByteArray().length;
                if (loop) {
                    exceptLength = tlvTools.calcValueLength(out.toByteArray(), 0, out.toByteArray().length);
                    loop = false;
                }
                if (readLength < exceptLength) continue;
                List<Tlv> unpackDataList = TlvTools.unpack(tlvList, TlvTools.bytesToHex(out.toByteArray()));
                if (unpackDataList.size() != 1) continue;
                TlvDataBody tLvDataBody = new TlvDataBody();
                tLvDataBody.setData(out.toByteArray());
                tLvDataBody.setTlv(unpackDataList.get(0));
                return tLvDataBody;
            }
        }
        catch (Exception e) {
            throw new ServiceException("read data from socket error caused by:" + e.getMessage());
        }
        return null;
    }

    public ASN1Sequence processing(Socket socketFd, IRequest request) throws Exception {
        int sock = this.write(socketFd, new SvsRequest(request).getEncoded());
        if (sock != 0) {
            throw new ServiceException("server time out");
        }
        TlvDataBody tlvDataBody = this.read(socketFd);
        if (tlvDataBody == null) {
            throw new ServiceException("socket read data error");
        }
        return ASN1Sequence.getInstance(tlvDataBody.getData());
    }
}

