/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.socket;

import com.xdja.svs.socket.Tlv;
import java.util.List;

public class TlvTools {
    private static char[] HEX_VOCABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static List<Tlv> unpack(List<Tlv> tlvList, String tlv) {
        int lenValue = 0;
        int tagLen = 0;
        byte[] data = TlvTools.hexStrToBytes(tlv);
        for (int current = 0; current < data.length; current += lenValue) {
            Tlv tlvData = new Tlv();
            tagLen = TlvTools.getTagLen(data, current);
            tlvData.setTag(TlvTools.getTagToInt(data, current, tagLen));
            if ((data[current += tagLen] & 0x80) == 128) {
                int tmpLen = data[current] & 0x7F;
                switch (tmpLen) {
                    case 1: {
                        lenValue = data[current + 1] & 0xFF;
                        break;
                    }
                    case 2: {
                        lenValue = (data[current + 1] << 8 & 0xFF00) + (data[current + 2] & 0xFF);
                        break;
                    }
                }
                current += tmpLen + 1;
            } else {
                lenValue = data[current] & 0xFF;
                ++current;
            }
            tlvData.setLen(lenValue);
            byte[] temp = new byte[lenValue];
            System.arraycopy(data, current, temp, 0, lenValue);
            tlvData.setValue(temp);
            tlvList.add(tlvData);
        }
        return tlvList;
    }

    public static byte[] hexStrToBytes(String data) {
        if (data == null || "".equals(data)) {
            return null;
        }
        int len = data.length() / 2;
        byte[] result = new byte[len];
        char[] chArr = data.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(TlvTools.toByte(chArr[pos]) << 4 | TlvTools.toByte(chArr[pos + 1]));
        }
        return result;
    }

    public static int getTagLen(byte[] data, int flag) {
        byte b;
        int tagLen = 1;
        for (int i = 0; i < 2 && ((b = data[i + flag]) & 0xF) == 15; ++i) {
            ++tagLen;
        }
        return tagLen;
    }

    public static byte toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    public static int getTagToInt(byte[] data, int flag, int len) {
        int mask = 255;
        int temp = 0;
        int result = 0;
        len = Math.min(len, 4);
        for (int i = 0; i < len; ++i) {
            result <<= 8;
            temp = data[flag + i] & mask;
            result |= temp;
        }
        return result;
    }

    public static String bytesToHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            int high = b >> 4 & 0xF;
            int low = b & 0xF;
            sb.append(HEX_VOCABLE[high]);
            sb.append(HEX_VOCABLE[low]);
        }
        return sb.toString();
    }

    public int calcValueLength(byte[] aBuf, int aOffset, int aLen) {
        int tagBytesCount = this.getTagBytesCount(aBuf, aOffset);
        int valueLength = this.getDataLength(aBuf, aOffset + tagBytesCount);
        return valueLength;
    }

    private int getTagBytesCount(byte[] aBuf, int aOffset) {
        if ((aBuf[aOffset] & 0x1F) == 31) {
            int len = 2;
            for (int i = aOffset + 1; i < aOffset + 10 && (aBuf[i] & 0x80) == 128; ++i) {
                ++len;
            }
            return len;
        }
        return 1;
    }

    public int getDataLength(byte[] aBuf, int aOffset) {
        int length = aBuf[aOffset] & 0xFF;
        if ((length & 0x80) == 128) {
            int numberOfBytes = length & 0x7F;
            if (numberOfBytes > 3) {
                throw new IllegalStateException(String.format("At position %d the len is more then 3 [%d]", aOffset, numberOfBytes));
            }
            length = 0;
            for (int i = aOffset + 1; i < aOffset + 1 + numberOfBytes; ++i) {
                length = length * 256 + (aBuf[i] & 0xFF);
            }
        }
        return length;
    }
}

