/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.utils;

import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.regex.Pattern;

public class ApiUtils {
    public static final int XML_TYPE_ENVELOPED = 0;
    public static final int XML_TYPE_ENVELOPING = 1;
    public static final int XML_TYPE_DETACH = 2;

    public static boolean matchedXmlType(int xmlType) throws SOR_ParameterNotSupportedException {
        if (xmlType == 0 || xmlType == 1 || xmlType == 2) {
            return true;
        }
        throw new SOR_ParameterNotSupportedException("the session of XmlType field is not support ");
    }

    public static boolean isNumeric(String value) {
        String pattern = "-?[0-9]+\\.?[0-9]*";
        return Pattern.matches(pattern, value);
    }

    public static boolean isBase64(String content) {
        String pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return Pattern.matches(pattern, content);
    }

    public static byte[] hex2byte(String hexString) {
        byte[] hexBytes = new byte[hexString.length() / 2];
        int len = hexString.length();
        for (int index = 0; index <= len - 1; index += 2) {
            String subString = hexString.substring(index, index + 2);
            int intValue = Integer.parseInt(subString, 16);
            hexBytes[index / 2] = (byte)intValue;
        }
        return hexBytes;
    }

    public static boolean checkPubKeyAlg(long signAlg, X509Certificate certificate) throws SOR_ParameterNotSupportedException {
        if (null == certificate) {
            throw new SOR_ParameterNotSupportedException("check PubKeyAlg : cert is null");
        }
        PublicKey publicKey = certificate.getPublicKey();
        return ApiUtils.checkPubKeyAlg(signAlg, publicKey);
    }

    public static boolean checkPubKeyAlg(long signAlg, PublicKey publicKey) throws SOR_ParameterNotSupportedException {
        if (publicKey == null) {
            return false;
        }
        if ("RSA".equals(publicKey.getAlgorithm()) ? SignAlg.matchRSAAlg(signAlg) : SignAlg.matchSm2Alg(signAlg)) {
            return true;
        }
        throw new SOR_ParameterNotSupportedException("pubkey is unmatched sign alg");
    }

    public static boolean verifyLevel(int verifyLevel) {
        return verifyLevel >= -1 && verifyLevel <= 2;
    }
}

