/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.utils;

import com.xdja.svs.common.Log;
import com.xdja.svs.execption.SOR_XmlEncodeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;

public class XmlSignUtils {
    public static final int ENVELOPED_TYPE_KEY = 1000;
    public static final int XML_ORIGIN_KEY = 1;
    public static final int DIGEST_VALUE_KEY = 2;
    public static final int SIGNATURE_VALUE_KEY = 3;
    public static final int SIGNATURE_CERT_KEY = 4;
    public static final int DIGEST_ALG_KEY = 5;
    public static final int SIGN_ALG_KEY = 6;
    static final String SIGNATURE_INFO_TAG = "Signature";
    static final String DIGEST_VALUE_TAG = "DigestValue";
    static final String SIGNATURE_VALUE_TAG = "SignatureValue";
    static final String DIGEST_ALG_TAG = "DigestMethod";
    static final String SIGN_ALG_TAG = "SignatureMethod";
    static final String SIGNED_INFO_TAG = "SignedInfo";
    static final String REFERENCE_INFO_TAG = "Reference";
    static final String KEY_INFO_TAG = "KeyInfo";
    static final String KEY_VALUE_TAG = "KeyValue";
    static final String EC_KEY_TAG = "ECKeyValue";
    static final String PUBLIC_KEY_TAG = "PublicKey";
    static final String RSA_KEY_TAG = "RSAKeyValue";
    static final String RSA_PUBLIC_KEY_TAG = "Modulus";
    static final String OBJECT_KEY_TAG = "Object";
    public static final String XML_HEADER_TAG = "IncludeXmlHeader";
    public static final String XML_NAMESPACE_HEADER_TAG = "IncludeXmlNameSpace";
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String XML_INCLUDE = "1";
    public static final String XML_EXCLUDE = "0";
    public static final String DEFAULT_ATTR_KEY = "xmlns";
    public static final String DEFAULT_ATTR_VALUE = "http://www.w3.org/2000/09/xmldsig#";
    public static final String UNSUPPORTED_ORIGIN_XML = "unsupported_origin_xml";

    private static Document validateXml(String XmlSignedData) throws SOR_XmlEncodeException {
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(new ByteArrayInputStream(XmlSignedData.getBytes()));
            return document;
        }
        catch (Exception e) {
            throw new SOR_XmlEncodeException("please check the value of xmlSignedData");
        }
    }

    public static Map<Integer, String> unMarshalXML(String XmlSignedData) throws Exception {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        Document document = XmlSignUtils.validateXml(XmlSignedData);
        Element root = document.getRootElement();
        Element object = root.element(OBJECT_KEY_TAG);
        if (root.getQName().getName().equals(SIGNATURE_INFO_TAG)) {
            Element signature = root;
            if (object == null) {
                result.put(1000, "2");
                XmlSignUtils.packCommonXmlValue(signature, result);
                result.put(1, UNSUPPORTED_ORIGIN_XML);
            } else {
                result.put(1000, XML_INCLUDE);
                XmlSignUtils.packCommonXmlValue(signature, result);
                DefaultElement defaultElement = (DefaultElement)object.elements().get(0);
                String xmlContent = XmlSignUtils.appendXmlHeader(signature, defaultElement.asXML());
                xmlContent = XmlSignUtils.removeXmlNameSpace(signature, xmlContent);
                result.put(1, xmlContent);
            }
        } else {
            result.put(1000, XML_EXCLUDE);
            Element signature = root.element(SIGNATURE_INFO_TAG);
            XmlSignUtils.packCommonXmlValue(signature, result);
            root.remove(signature);
            String xmlContent = XmlSignUtils.appendXmlHeader(signature, root.asXML());
            xmlContent = XmlSignUtils.removeXmlNameSpace(signature, xmlContent);
            result.put(1, xmlContent);
        }
        return result;
    }

    public static String asXml(Element body) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        format.setTrimText(true);
        format.setExpandEmptyElements(true);
        StringWriter out = new StringWriter();
        XMLWriter writer = new XMLWriter(out, format);
        try {
            writer.write(body);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    private static String appendXmlHeader(Element signature, String xmlContent) {
        Element xmlHeader = signature.element(XML_HEADER_TAG);
        if (XML_INCLUDE.equals(xmlHeader.getText())) {
            xmlContent = XML_HEADER + xmlContent;
            Log.print("append xml header to content success");
        } else {
            Log.print("origin xml content exclude xml header");
        }
        return xmlContent;
    }

    private static String removeXmlNameSpace(Element signature, String xmlContent) {
        Element xmlNameSpace = signature.element(XML_NAMESPACE_HEADER_TAG);
        if (XML_EXCLUDE.equals(xmlNameSpace.getText())) {
            xmlContent = xmlContent.replaceAll("\\s+xmlns=\"http://www.w3.org/2000/09/xmldsig#\"", "");
            Log.print("xml remove extra xml namespace");
        } else {
            Log.print("origin xml content include xml namespace");
        }
        return xmlContent;
    }

    private static void packCommonXmlValue(Element root, Map<Integer, String> result) throws SOR_XmlEncodeException {
        if (root == null) {
            throw new SOR_XmlEncodeException("check xml style");
        }
        Element signedInfo = root.element(SIGNED_INFO_TAG);
        Element reference = signedInfo.element(REFERENCE_INFO_TAG);
        Element digestValue = reference.element(DIGEST_VALUE_TAG);
        result.put(2, digestValue.getText());
        Element signatureValue = root.element(SIGNATURE_VALUE_TAG);
        result.put(3, signatureValue.getText());
        Element keyInfo = root.element(KEY_INFO_TAG);
        Element keyValue = keyInfo.element(KEY_VALUE_TAG);
        Element ecKeyValue = keyValue.element(EC_KEY_TAG);
        if (ecKeyValue == null) {
            Element rsaKeyValue = keyValue.element(RSA_KEY_TAG);
            Element publicKeyValue = rsaKeyValue.element(RSA_PUBLIC_KEY_TAG);
            result.put(4, publicKeyValue.getText());
        } else {
            Element publicKeyValue = ecKeyValue.element(PUBLIC_KEY_TAG);
            result.put(4, publicKeyValue.getText());
        }
        Element digestMethod = reference.element(DIGEST_ALG_TAG);
        result.put(5, digestMethod.attribute("Algorithm").getValue());
        Element signMethod = signedInfo.element(SIGN_ALG_TAG);
        result.put(6, signMethod.attribute("Algorithm").getText());
    }
}

