/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.utils;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.EmptyUtils;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class XmlSignedVerifyUtils {
    private static Element setCanonicalizationMethod(Element signedInfo) {
        Element canonicalizationMethod = signedInfo.addElement("CanonicalizationMethod");
        canonicalizationMethod.addAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        return canonicalizationMethod;
    }

    private static Element setSignatureMethod(Element signedInfo, long signMethod) {
        Element signatureMethod = signedInfo.addElement("SignatureMethod");
        if (signMethod == SignAlg.SM3_SM2.getAlgId()) {
            signatureMethod.addAttribute("Algorithm", "http://127.0.0.1/2001/04/xmldsig-more#sm2-sm3");
        } else if (signMethod == SignAlg.SM3_RSA.getAlgId()) {
            signatureMethod.addAttribute("Algorithm", "http://127.0.0.1/2001/04/xmldsig-more#rsa-sm3");
        } else if (signMethod == SignAlg.SHA1_RSA.getAlgId()) {
            signatureMethod.addAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        } else if (signMethod == SignAlg.SHA256_RSA.getAlgId()) {
            signatureMethod.addAttribute("Algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        } else if (signMethod == SignAlg.SHA1_ECDSA.getAlgId() || signMethod == SignAlg.SHA256_ECDSA.getAlgId()) {
            // empty if block
        }
        return signatureMethod;
    }

    private static Element setReference(Element signedInfo, String originXML, long signMethod) throws Exception {
        Element reference = signedInfo.addElement("Reference");
        reference.addAttribute("URI", "");
        Element transforms = reference.addElement("Transforms");
        Element transforms1 = transforms.addElement("Transform");
        transforms1.addAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        Element digestMethod = reference.addElement("DigestMethod");
        Element digestValue = reference.addElement("DigestValue");
        if (signMethod == SignAlg.SM3_SM2.getAlgId() || signMethod == SignAlg.SM3_RSA.getAlgId()) {
            digestMethod.addAttribute("Algorithm", "http://127.0.0.1/2001/04/xmldsig-more#sm3");
            byte[] digest = GMSSLSM3DigestUtils.digest(originXML.getBytes(StandardCharsets.UTF_8));
            digestValue.addText(Base64Utils.encode(digest));
        } else if (signMethod == SignAlg.SHA1_RSA.getAlgId()) {
            digestMethod.addAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
            byte[] digest = GMSSLSHA1DigestUtils.digest(originXML.getBytes(StandardCharsets.UTF_8));
            digestValue.addText(Base64Utils.encode(digest));
        } else if (signMethod == SignAlg.SHA256_RSA.getAlgId()) {
            digestMethod.addAttribute("Algorithm", "http://www.w3.org/2001/04/xmlenc#sha256");
            byte[] digest = GMSSLSHA256DigestUtils.digest(originXML.getBytes(StandardCharsets.UTF_8));
            digestValue.addText(Base64Utils.encode(digest));
        } else if (signMethod == SignAlg.SHA1_ECDSA.getAlgId() || signMethod == SignAlg.SHA256_ECDSA.getAlgId()) {
            // empty if block
        }
        return reference;
    }

    private static Element setSignValue(Element signature, String signValue) {
        Element signatureValue = signature.addElement("SignatureValue");
        signatureValue.addText(signValue);
        return signatureValue;
    }

    private static Element setKeyInfo(Element signature, X509Certificate x509Certificate) {
        Element keyInfo = signature.addElement("KeyInfo");
        Element keyValue = keyInfo.addElement("KeyValue");
        if ("EC".equals(x509Certificate.getPublicKey().getAlgorithm())) {
            Element eccKeyValue = keyValue.addElement("ECKeyValue");
            Element namedCurve = eccKeyValue.addElement("NamedCurve");
            namedCurve.addAttribute(QName.get("URI"), "sm2:oid:1.2.156.10197.6.1.4.2.2");
            Element publicKey = eccKeyValue.addElement("PublicKey");
            try {
                publicKey.addText(Base64Utils.encode(x509Certificate.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                e.printStackTrace();
            }
        } else {
            Element rsaKeyValue = keyValue.addElement("RSAKeyValue");
            Element modulus = rsaKeyValue.addElement("Modulus");
            try {
                modulus.addText(Base64Utils.encode(x509Certificate.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                e.printStackTrace();
            }
            Element exponent = rsaKeyValue.addElement("Exponent");
            exponent.addText(Base64Utils.encode(((RSAPublicKey)x509Certificate.getPublicKey()).getPublicExponent().toByteArray()));
        }
        return keyInfo;
    }

    private static Element setOriginXML(Element signature, String originXML) {
        try {
            Element object = signature.addElement("Object");
            Document document = DocumentHelper.parseText(originXML);
            Element rootElement = document.getRootElement();
            object.add(rootElement);
            return object;
        }
        catch (DocumentException e) {
            return null;
        }
    }

    private static Element packetSignatureElement(long signMethod, Document document, String signValue, X509Certificate x509Certificate, boolean originisNull, String originXML) {
        Element signature = document.addElement("Signature");
        signature.addAttribute("xmlns", "http://www.w3.org/2000/09/xmldsig#");
        Element signedInfo = signature.addElement("SignedInfo");
        XmlSignedVerifyUtils.setCanonicalizationMethod(signedInfo);
        XmlSignedVerifyUtils.setSignatureMethod(signedInfo, signMethod);
        try {
            XmlSignedVerifyUtils.setReference(signedInfo, originXML, signMethod);
        }
        catch (Exception e) {
            return null;
        }
        XmlSignedVerifyUtils.setSignValue(signature, signValue);
        XmlSignedVerifyUtils.setKeyInfo(signature, x509Certificate);
        if (!originisNull) {
            XmlSignedVerifyUtils.setOriginXML(signature, originXML);
        }
        XmlSignedVerifyUtils.includeXmlHeader(signature, originXML);
        XmlSignedVerifyUtils.includeXmlNameSpace(signature, originXML);
        return signature;
    }

    private static void includeXmlHeader(Element signature, String originXML) {
        Element xmlHeader = signature.addElement("IncludeXmlHeader");
        if (originXML.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
            xmlHeader.setText("1");
        } else {
            xmlHeader.setText("0");
        }
    }

    private static void includeXmlNameSpace(Element signature, String originXML) {
        Element nameSpaceHeader = signature.addElement("IncludeXmlNameSpace");
        try {
            Document originDocument = DocumentHelper.parseText(originXML);
            Element root = originDocument.getRootElement();
            Namespace nameSpace = root.getNamespace();
            if (nameSpace != null && !EmptyUtils.isEmpty(nameSpace.getURI())) {
                nameSpaceHeader.setText("1");
            } else {
                nameSpaceHeader.setText("0");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String packetXMLEnveloping(X509Certificate x509Certificate, String originXML, long signMethod, String signValue) {
        try {
            Document document = DocumentHelper.parseText(originXML);
            Element rootElement = document.getRootElement();
            Document documentnew = DocumentHelper.createDocument();
            Element signature = XmlSignedVerifyUtils.packetSignatureElement(signMethod, documentnew, signValue, x509Certificate, true, originXML);
            rootElement.add(signature);
            return document.asXML();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String packetXMLEnveloped(X509Certificate x509Certificate, String originXML, long signMethod, String signValue) {
        Document document = DocumentHelper.createDocument();
        XmlSignedVerifyUtils.packetSignatureElement(signMethod, document, signValue, x509Certificate, false, originXML);
        return document.asXML();
    }

    public static String packetXMLDetached(X509Certificate x509Certificate, String originXML, long signMethod, String signValue) {
        Document document = DocumentHelper.createDocument();
        XmlSignedVerifyUtils.packetSignatureElement(signMethod, document, signValue, x509Certificate, true, originXML);
        return document.asXML();
    }
}

