/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.translator.ImageServingTranslator;
import ai.djl.modality.cv.translator.SemanticSegmentationTranslator;
import ai.djl.modality.cv.translator.wrapper.FileTranslator;
import ai.djl.modality.cv.translator.wrapper.InputStreamTranslator;
import ai.djl.modality.cv.translator.wrapper.UrlTranslator;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SemanticSegmentationTranslatorFactory
implements TranslatorFactory {
    private static final Set<Pair<Type, Type>> SUPPORTED_TYPES = new HashSet<Pair<Type, Type>>();

    @Override
    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) {
        SemanticSegmentationTranslator translator = SemanticSegmentationTranslator.builder(arguments).build();
        if (input == Image.class && output == Image.class) {
            return translator;
        }
        if (input == Path.class && output == Image.class) {
            return new FileTranslator<Image>(translator);
        }
        if (input == URL.class && output == Image.class) {
            return new UrlTranslator<Image>(translator);
        }
        if (input == InputStream.class && output == Image.class) {
            return new InputStreamTranslator<Image>(translator);
        }
        if (input == Input.class && output == Output.class) {
            return new ImageServingTranslator(translator);
        }
        throw new IllegalArgumentException("Unsupported input/output types.");
    }

    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    static {
        SUPPORTED_TYPES.add(new Pair<Class<Image>, Class<Image>>(Image.class, Image.class));
    }
}

