/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray.index;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.index.dim.NDIndexBooleans;
import ai.djl.ndarray.index.dim.NDIndexElement;
import ai.djl.ndarray.index.full.NDIndexFullPick;
import ai.djl.ndarray.index.full.NDIndexFullSlice;
import ai.djl.ndarray.index.full.NDIndexFullTake;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NDArrayIndexer {
    public abstract NDArray get(NDArray var1, NDIndexFullPick var2);

    public abstract NDArray get(NDArray var1, NDIndexFullTake var2);

    public abstract NDArray get(NDArray var1, NDIndexFullSlice var2);

    public NDArray get(NDArray array, NDIndex index) {
        if (index.getRank() == 0 && array.getShape().isScalar()) {
            return array.duplicate();
        }
        List<NDIndexElement> indices = index.getIndices();
        if (!indices.isEmpty() && indices.get(0) instanceof NDIndexBooleans) {
            if (indices.size() != 1) {
                throw new IllegalArgumentException("get() currently doesn't support more that one boolean NDArray");
            }
            return array.booleanMask(((NDIndexBooleans)indices.get(0)).getIndex());
        }
        Optional<NDIndexFullTake> fullTake = NDIndexFullTake.fromIndex(index, array.getShape());
        if (fullTake.isPresent()) {
            Logger logger = LoggerFactory.getLogger(NDArrayIndexer.class);
            logger.warn("The definition of the getter by array NDIndex: get(NDIndex array) has changed from pick to take.If you still want to use array index as pick, then do it explicitly by get(new NDIndex().addPickDim(array));");
            return this.get(array, fullTake.get());
        }
        Optional<NDIndexFullPick> fullPick = NDIndexFullPick.fromIndex(index, array.getShape());
        if (fullPick.isPresent()) {
            return this.get(array, fullPick.get());
        }
        Optional<NDIndexFullSlice> fullSlice = NDIndexFullSlice.fromIndex(index, array.getShape());
        if (fullSlice.isPresent()) {
            return this.get(array, fullSlice.get());
        }
        throw new UnsupportedOperationException("get() currently supports all, fixed, and slices indices");
    }

    public void set(NDArray array, NDIndex index, Object value) {
        NDIndexFullSlice fullSlice = NDIndexFullSlice.fromIndex(index, array.getShape()).orElse(null);
        if (fullSlice != null) {
            if (value instanceof Number) {
                this.set(array, fullSlice, (Number)value);
            } else if (value instanceof NDArray) {
                this.set(array, fullSlice, (NDArray)value);
            } else {
                throw new IllegalArgumentException("The type of value to assign cannot be other than NDArray and Number.");
            }
            return;
        }
        List<NDIndexElement> indices = index.getIndices();
        if (!indices.isEmpty() && indices.get(0) instanceof NDIndexBooleans) {
            if (indices.size() != 1) {
                throw new IllegalArgumentException("set() currently doesn't support more than one boolean NDArray");
            }
            if (value instanceof Number) {
                this.set(array, (NDIndexBooleans)indices.get(0), array.getManager().create((Number)value));
            } else if (value instanceof NDArray) {
                this.set(array, (NDIndexBooleans)indices.get(0), (NDArray)value);
            } else {
                throw new IllegalArgumentException("The type of value to assign cannot be other than NDArray and Number.");
            }
        }
        throw new UnsupportedOperationException("set() currently supports all, fixed, and slices indices");
    }

    public abstract void set(NDArray var1, NDIndexFullSlice var2, NDArray var3);

    public void set(NDArray array, NDIndexBooleans indices, NDArray value) {
        array.intern(NDArrays.where(indices.getIndex(), value, array));
    }

    public abstract void set(NDArray var1, NDIndexFullSlice var2, Number var3);

    public void setScalar(NDArray array, NDIndex index, Number value) {
        NDIndexFullSlice fullSlice = NDIndexFullSlice.fromIndex(index, array.getShape()).orElse(null);
        if (fullSlice != null) {
            if (fullSlice.getShape().size() != 1L) {
                throw new IllegalArgumentException("The provided index does not set a scalar");
            }
            this.set(array, index, (Object)value);
            return;
        }
        throw new UnsupportedOperationException("set() currently supports all, fixed, and slices indices");
    }
}

