/*
 * Decompiled with CFR 0.152.
 */
package android.arch.paging;

import android.arch.paging.PagedStorage;
import android.support.annotation.Nullable;
import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;

class PagedStorageDiffHelper {
    private PagedStorageDiffHelper() {
    }

    static <T> DiffUtil.DiffResult computeDiff(final PagedStorage<T> oldList, final PagedStorage<T> newList, final DiffUtil.ItemCallback<T> diffCallback) {
        final int oldOffset = oldList.computeLeadingNulls();
        int newOffset = newList.computeLeadingNulls();
        final int oldSize = oldList.size() - oldOffset - oldList.computeTrailingNulls();
        final int newSize = newList.size() - newOffset - newList.computeTrailingNulls();
        return DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtil.Callback(){

            @Nullable
            public Object getChangePayload(int oldItemPosition, int newItemPosition) {
                Object oldItem = oldList.get(oldItemPosition + oldOffset);
                Object newItem = newList.get(newItemPosition + newList.getLeadingNullCount());
                if (oldItem == null || newItem == null) {
                    return null;
                }
                return diffCallback.getChangePayload(oldItem, newItem);
            }

            public int getOldListSize() {
                return oldSize;
            }

            public int getNewListSize() {
                return newSize;
            }

            public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                Object newItem;
                Object oldItem = oldList.get(oldItemPosition + oldOffset);
                if (oldItem == (newItem = newList.get(newItemPosition + newList.getLeadingNullCount()))) {
                    return true;
                }
                if (oldItem == null || newItem == null) {
                    return false;
                }
                return diffCallback.areItemsTheSame(oldItem, newItem);
            }

            public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                Object newItem;
                Object oldItem = oldList.get(oldItemPosition + oldOffset);
                if (oldItem == (newItem = newList.get(newItemPosition + newList.getLeadingNullCount()))) {
                    return true;
                }
                if (oldItem == null || newItem == null) {
                    return false;
                }
                return diffCallback.areContentsTheSame(oldItem, newItem);
            }
        }, (boolean)true);
    }

    static <T> void dispatchDiff(ListUpdateCallback callback, PagedStorage<T> oldList, PagedStorage<T> newList, DiffUtil.DiffResult diffResult) {
        int trailingOld = oldList.computeTrailingNulls();
        int trailingNew = newList.computeTrailingNulls();
        int leadingOld = oldList.computeLeadingNulls();
        int leadingNew = newList.computeLeadingNulls();
        if (trailingOld == 0 && trailingNew == 0 && leadingOld == 0 && leadingNew == 0) {
            diffResult.dispatchUpdatesTo(callback);
            return;
        }
        if (trailingOld > trailingNew) {
            int count = trailingOld - trailingNew;
            callback.onRemoved(oldList.size() - count, count);
        } else if (trailingOld < trailingNew) {
            callback.onInserted(oldList.size(), trailingNew - trailingOld);
        }
        if (leadingOld > leadingNew) {
            callback.onRemoved(0, leadingOld - leadingNew);
        } else if (leadingOld < leadingNew) {
            callback.onInserted(0, leadingNew - leadingOld);
        }
        if (leadingNew != 0) {
            diffResult.dispatchUpdatesTo((ListUpdateCallback)new OffsettingListUpdateCallback(leadingNew, callback));
        } else {
            diffResult.dispatchUpdatesTo(callback);
        }
    }

    private static class OffsettingListUpdateCallback
    implements ListUpdateCallback {
        private final int mOffset;
        private final ListUpdateCallback mCallback;

        private OffsettingListUpdateCallback(int offset, ListUpdateCallback callback) {
            this.mOffset = offset;
            this.mCallback = callback;
        }

        public void onInserted(int position, int count) {
            this.mCallback.onInserted(position + this.mOffset, count);
        }

        public void onRemoved(int position, int count) {
            this.mCallback.onRemoved(position + this.mOffset, count);
        }

        public void onMoved(int fromPosition, int toPosition) {
            this.mCallback.onMoved(fromPosition + this.mOffset, toPosition + this.mOffset);
        }

        public void onChanged(int position, int count, Object payload) {
            this.mCallback.onChanged(position + this.mOffset, count, payload);
        }
    }
}

