/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.store;

import android.databinding.tool.Context;
import android.databinding.tool.reflection.ImportBag;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.annotation.AnnotationTypeUtil;
import android.databinding.tool.store.BindingAdapterStore;
import android.databinding.tool.util.GenerationalClassUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;

public class SetterStore {
    private static final int ASSIGNABLE_CONVERSION = 1;
    private final BindingAdapterStore mStore;
    private final ModelAnalyzer mClassAnalyzer;
    private HashMap<String, List<String>> mInstanceAdapters;
    private final Set<String> mInverseEventAttributes;
    private Comparator<MultiAttributeSetter> COMPARE_MULTI_ATTRIBUTE_SETTERS = new Comparator<MultiAttributeSetter>(){

        @Override
        public int compare(MultiAttributeSetter o1, MultiAttributeSetter o2) {
            ModelClass view2;
            if (o1.attributes.length != o2.attributes.length) {
                return o2.attributes.length - o1.attributes.length;
            }
            if (((MultiAttributeSetter)o1).mKey.attributeIndices.size() != ((MultiAttributeSetter)o2).mKey.attributeIndices.size()) {
                return ((MultiAttributeSetter)o2).mKey.attributeIndices.size() - ((MultiAttributeSetter)o1).mKey.attributeIndices.size();
            }
            ModelClass view1 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o1).mKey.viewType, null).erasure();
            if (!view1.equals(view2 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o2).mKey.viewType, null).erasure())) {
                if (view1.isAssignableFrom(view2)) {
                    return 1;
                }
                return -1;
            }
            if (!((MultiAttributeSetter)o1).mKey.attributeIndices.keySet().equals(((MultiAttributeSetter)o2).mKey.attributeIndices.keySet())) {
                Iterator<String> o1Keys = ((MultiAttributeSetter)o1).mKey.attributeIndices.keySet().iterator();
                Iterator<String> o2Keys = ((MultiAttributeSetter)o2).mKey.attributeIndices.keySet().iterator();
                while (o1Keys.hasNext() && o2Keys.hasNext()) {
                    String key2;
                    String key1 = o1Keys.next();
                    int compare = key1.compareTo(key2 = o2Keys.next());
                    if (compare == 0) continue;
                    return compare;
                }
                Preconditions.check((boolean)false, (String)"The sets don't match! That means the keys shouldn't match also", (Object[])new Object[0]);
            }
            for (String attribute : ((MultiAttributeSetter)o1).mKey.attributeIndices.keySet()) {
                ModelClass type2;
                int index1 = ((MultiAttributeSetter)o1).mKey.attributeIndices.get(attribute);
                int index2 = ((MultiAttributeSetter)o2).mKey.attributeIndices.get(attribute);
                ModelClass type1 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o1).mKey.parameterTypes[index1], null);
                if (type1.equals(type2 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o2).mKey.parameterTypes[index2], null))) continue;
                if (o1.mCasts[index1] != null) {
                    if (o2.mCasts[index2] != null) continue;
                    return 1;
                }
                if (o2.mCasts[index2] != null) {
                    return -1;
                }
                if (o1.mConverters[index1] != null) {
                    if (o2.mConverters[index2] != null) continue;
                    return 1;
                }
                if (o2.mConverters[index2] != null) {
                    return -1;
                }
                if (type1.isPrimitive()) {
                    if (type2.isPrimitive()) {
                        int type1ConversionLevel = ModelMethod.getImplicitConversionLevel(type1);
                        int type2ConversionLevel = ModelMethod.getImplicitConversionLevel(type2);
                        return type2ConversionLevel - type1ConversionLevel;
                    }
                    return -1;
                }
                if (type2.isPrimitive()) {
                    return 1;
                }
                if (type1.isAssignableFrom(type2)) {
                    return 1;
                }
                if (!type2.isAssignableFrom(type1)) continue;
                return -1;
            }
            return 0;
        }
    };

    private SetterStore(ModelAnalyzer modelAnalyzer, BindingAdapterStore store) {
        this.mClassAnalyzer = modelAnalyzer;
        this.mStore = store;
        this.mStore.setAsMainStore();
        this.mInverseEventAttributes = this.mStore.collectInverseEvents();
    }

    public static SetterStore get() {
        return Context.getSetterStore();
    }

    public static SetterStore create(ModelAnalyzer modelAnalyzer, GenerationalClassUtil generationalClassUtil) {
        return SetterStore.load(modelAnalyzer, generationalClassUtil);
    }

    private static SetterStore load(ModelAnalyzer modelAnalyzer, GenerationalClassUtil generationalClassUtil) {
        List<Intermediate> previousStores = generationalClassUtil.load(GenerationalClassUtil.ExtensionFilter.SETTER_STORE, Intermediate.class);
        List<BindingAdapterStore> gsonIntermediates = generationalClassUtil.load(GenerationalClassUtil.ExtensionFilter.SETTER_STORE_JSON, BindingAdapterStore.class);
        BindingAdapterStore store = new BindingAdapterStore(previousStores, gsonIntermediates, modelAnalyzer.libTypes.getUseAndroidX());
        return new SetterStore(modelAnalyzer, store);
    }

    public void addRenamedMethod(String attribute, String declaringClass, String method, TypeElement declaredOn) {
        attribute = SetterStore.stripNamespace(attribute);
        MethodDescription methodDescription = new MethodDescription(declaredOn.getQualifiedName().toString(), method);
        this.mStore.addRenamedMethod(attribute, declaringClass, methodDescription);
    }

    public void addInverseBindingMethod(String attribute, String event, String declaringClass, String method, TypeElement declaredOn) {
        attribute = SetterStore.stripNamespace(attribute);
        event = SetterStore.stripNamespace(event);
        InverseDescription methodDescription = new InverseDescription(declaredOn.getQualifiedName().toString(), method, event);
        this.mStore.addInverseBindingMethod(attribute, declaringClass, methodDescription);
    }

    public void addInverseMethod(ProcessingEnvironment processingEnvironment, ExecutableElement method, ExecutableElement inverse) {
        InverseMethodDescription from = new InverseMethodDescription(processingEnvironment, method);
        InverseMethodDescription to = new InverseMethodDescription(processingEnvironment, inverse);
        this.mStore.addInverseMethod(from, to);
    }

    public void addBindingAdapter(ProcessingEnvironment processingEnv, String attribute, ExecutableElement bindingMethod, boolean takesComponent) {
        attribute = SetterStore.stripNamespace(attribute);
        L.d((String)"STORE addBindingAdapter %s %s", (Object[])new Object[]{attribute, bindingMethod});
        List<? extends VariableElement> parameters = bindingMethod.getParameters();
        int viewIndex = takesComponent ? 1 : 0;
        TypeMirror viewType = SetterStore.eraseType(processingEnv, parameters.get(viewIndex).asType());
        String view = SetterStore.getQualifiedName(viewType);
        TypeMirror parameterType = SetterStore.eraseType(processingEnv, parameters.get(viewIndex + 1).asType());
        String value = SetterStore.getQualifiedName(parameterType);
        AccessorKey key = new AccessorKey(view, value);
        MethodDescription desc = new MethodDescription(bindingMethod, 1, takesComponent);
        this.mStore.addBindingAdapter(attribute, key, desc);
    }

    public void addInverseAdapter(ProcessingEnvironment processingEnv, String attribute, String event, ExecutableElement bindingMethod, boolean takesComponent) {
        attribute = SetterStore.stripNamespace(attribute);
        event = SetterStore.stripNamespace(event);
        L.d((String)"STORE addInverseAdapter %s %s", (Object[])new Object[]{attribute, bindingMethod});
        List<? extends VariableElement> parameters = bindingMethod.getParameters();
        int viewIndex = takesComponent ? 1 : 0;
        TypeMirror viewType = SetterStore.eraseType(processingEnv, parameters.get(viewIndex).asType());
        String view = SetterStore.getQualifiedName(viewType);
        TypeMirror returnType = SetterStore.eraseType(processingEnv, bindingMethod.getReturnType());
        String value = SetterStore.getQualifiedName(returnType);
        AccessorKey key = new AccessorKey(view, value);
        InverseDescription desc = new InverseDescription(bindingMethod, event, takesComponent);
        this.mStore.addInverseBindingAdapter(attribute, key, desc);
    }

    private static TypeMirror eraseType(ProcessingEnvironment processingEnv, TypeMirror typeMirror) {
        if (SetterStore.hasTypeVar(typeMirror)) {
            return processingEnv.getTypeUtils().erasure(typeMirror);
        }
        return typeMirror;
    }

    private static ModelClass eraseType(ModelClass modelClass) {
        if (SetterStore.hasTypeVar(modelClass)) {
            return modelClass.erasure();
        }
        return modelClass;
    }

    private static boolean hasTypeVar(TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        if (kind == TypeKind.TYPEVAR) {
            return true;
        }
        if (kind == TypeKind.ARRAY) {
            return SetterStore.hasTypeVar(((ArrayType)typeMirror).getComponentType());
        }
        if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            List<? extends TypeMirror> typeArguments2 = declaredType.getTypeArguments();
            if (typeArguments2 == null || typeArguments2.isEmpty()) {
                return false;
            }
            for (TypeMirror typeMirror2 : typeArguments2) {
                if (!SetterStore.hasTypeVar(typeMirror2)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean hasTypeVar(ModelClass type) {
        if (type.isTypeVar()) {
            return true;
        }
        if (type.isArray()) {
            return SetterStore.hasTypeVar(type.getComponentType());
        }
        List<ModelClass> typeArguments2 = type.getTypeArguments();
        if (typeArguments2 == null) {
            return false;
        }
        for (ModelClass arg : typeArguments2) {
            if (!SetterStore.hasTypeVar(arg)) continue;
            return true;
        }
        return false;
    }

    public void addBindingAdapter(ProcessingEnvironment processingEnv, String[] attributes, ExecutableElement bindingMethod, boolean takesComponent, boolean requireAll) {
        L.d((String)"STORE add multi-value BindingAdapter %d %s", (Object[])new Object[]{attributes.length, bindingMethod});
        MultiValueAdapterKey key = new MultiValueAdapterKey(processingEnv, bindingMethod, attributes, takesComponent, requireAll);
        SetterStore.testRepeatedAttributes(key, bindingMethod);
        MethodDescription methodDescription = new MethodDescription(bindingMethod, attributes.length, takesComponent);
        this.mStore.addMultiValueAdapter(key, methodDescription);
    }

    private static void testRepeatedAttributes(MultiValueAdapterKey key, ExecutableElement method) {
        if (key.attributes.length != key.attributeIndices.size()) {
            HashSet<String> names = new HashSet<String>();
            for (String attr : key.attributes) {
                if (names.contains(attr)) {
                    L.e((Element)method, (String)("Attribute \"" + attr + "\" is supplied multiple times in BindingAdapter " + method.toString()), (Object[])new Object[0]);
                }
                names.add(attr);
            }
        }
    }

    private static String[] stripAttributes(String[] attributes) {
        String[] strippedAttributes = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i] == null) continue;
            strippedAttributes[i] = SetterStore.stripNamespace(attributes[i]);
        }
        return strippedAttributes;
    }

    public void addUntaggableTypes(String[] typeNames, TypeElement declaredOn) {
        L.d((String)"STORE addUntaggableTypes %s %s", (Object[])new Object[]{Arrays.toString(typeNames), declaredOn});
        String declaredType = declaredOn.getQualifiedName().toString();
        this.mStore.addUntaggableType(typeNames, declaredType);
    }

    private static String getQualifiedName(TypeMirror type) {
        TypeKind kind = type.getKind();
        if (kind == TypeKind.ARRAY) {
            return SetterStore.getQualifiedName(((ArrayType)type).getComponentType()) + "[]";
        }
        if (kind == TypeKind.DECLARED && SetterStore.isIncompleteType(type)) {
            DeclaredType declaredType = (DeclaredType)type;
            return declaredType.asElement().toString();
        }
        return AnnotationTypeUtil.getInstance().toJava(type);
    }

    private static boolean isIncompleteType(TypeMirror type) {
        TypeKind kind = type.getKind();
        if (kind == TypeKind.TYPEVAR || kind == TypeKind.WILDCARD) {
            return true;
        }
        if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
            if (typeArgs == null) {
                return false;
            }
            for (TypeMirror typeMirror : typeArgs) {
                if (!SetterStore.isIncompleteType(typeMirror)) continue;
                return true;
            }
        }
        return false;
    }

    public void addConversionMethod(ExecutableElement conversionMethod) {
        L.d((String)"STORE addConversionMethod %s", (Object[])new Object[]{conversionMethod});
        List<? extends VariableElement> parameters = conversionMethod.getParameters();
        String fromType = SetterStore.getQualifiedName(parameters.get(0).asType());
        String toType = SetterStore.getQualifiedName(conversionMethod.getReturnType());
        MethodDescription methodDescription = new MethodDescription(conversionMethod, 1, false);
        this.mStore.addConversionMethod(fromType, toType, methodDescription);
    }

    public void clear(Set<String> classes) {
        this.mStore.clear(classes);
    }

    public void write(String projectPackage) throws IOException {
        Preconditions.checkNotNull((Object)this.mStore.getCurrentModuleStore(), (String)"current module store should not be null", (Object[])new Object[0]);
        GenerationalClassUtil.get().write(projectPackage, GenerationalClassUtil.ExtensionFilter.SETTER_STORE_JSON, this.mStore.getCurrentModuleStore());
    }

    private static String stripNamespace(String attribute) {
        int colon;
        if (!attribute.startsWith("android:") && (colon = attribute.indexOf(58)) >= 0) {
            attribute = attribute.substring(colon + 1);
        }
        return attribute;
    }

    public boolean isTwoWayEventAttribute(String attribute) {
        attribute = SetterStore.stripNamespace(attribute);
        return this.mInverseEventAttributes.contains(attribute);
    }

    public List<MultiAttributeSetter> getMultiAttributeSetterCalls(String[] attributes, ModelClass viewType, ModelClass[] valueType) {
        attributes = SetterStore.stripAttributes(attributes);
        ArrayList<MultiAttributeSetter> calls = new ArrayList<MultiAttributeSetter>();
        if (viewType != null && viewType.isGeneric()) {
            List<ModelClass> viewGenerics = viewType.getTypeArguments();
            for (int i = 0; i < valueType.length; ++i) {
                valueType[i] = SetterStore.eraseType(valueType[i], viewGenerics);
            }
            viewType = viewType.erasure();
        }
        ArrayList<MultiAttributeSetter> matching = this.getMatchingMultiAttributeSetters(attributes, viewType, valueType);
        Collections.sort(matching, this.COMPARE_MULTI_ATTRIBUTE_SETTERS);
        while (!matching.isEmpty()) {
            MultiAttributeSetter bestMatch = matching.get(0);
            calls.add(bestMatch);
            SetterStore.removeConsumedAttributes(matching, bestMatch.attributes);
        }
        return calls;
    }

    public Map<String, List<String>> getComponentBindingAdapters() {
        this.ensureInstanceAdapters();
        return this.mInstanceAdapters;
    }

    private String getBindingAdapterCall(String className) {
        this.ensureInstanceAdapters();
        String simpleName2 = BindingAdapterStore.simpleName(className);
        List<String> adapters = this.mInstanceAdapters.get(simpleName2);
        if (adapters.size() == 1) {
            return "get" + simpleName2 + "()";
        }
        int index = adapters.indexOf(className) + 1;
        return "get" + simpleName2 + index + "()";
    }

    private void ensureInstanceAdapters() {
        if (this.mInstanceAdapters == null) {
            this.mInstanceAdapters = this.mStore.createInstanceAdapters();
        }
    }

    private static void removeConsumedAttributes(ArrayList<MultiAttributeSetter> matching, String[] attributes) {
        for (int i = matching.size() - 1; i >= 0; --i) {
            MultiAttributeSetter setter = matching.get(i);
            boolean found = false;
            for (String attribute : attributes) {
                if (!SetterStore.isInArray(attribute, setter.attributes)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            matching.remove(i);
        }
    }

    private static boolean isInArray(String str, String[] array) {
        for (String value : array) {
            if (!value.equals(str)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<MultiAttributeSetter> getMatchingMultiAttributeSetters(String[] attributes, ModelClass viewType, ModelClass[] valueType) {
        return this.mStore.findMultiValueAdapters((Function2<? super MultiValueAdapterKey, ? super MethodDescription, ? extends MultiAttributeSetter>)((Function2)(adapter, method) -> {
            if (adapter.requireAll && adapter.attributes.length > attributes.length) {
                return null;
            }
            ModelClass viewClass = this.mClassAnalyzer.findClass(adapter.viewType, null);
            if (viewClass == null) {
                return null;
            }
            if (viewClass.isGeneric()) {
                viewClass = viewClass.erasure();
            }
            if (!viewClass.isAssignableFrom(viewType)) {
                return null;
            }
            return this.createMultiAttributeSetter((MethodDescription)method, attributes, valueType, (MultiValueAdapterKey)adapter);
        }));
    }

    private MultiAttributeSetter createMultiAttributeSetter(MethodDescription method, String[] allAttributes, ModelClass[] attributeValues, MultiValueAdapterKey adapter) {
        int matchingAttributes = 0;
        String[] casts = new String[adapter.attributes.length];
        MethodDescription[] conversions = new MethodDescription[adapter.attributes.length];
        boolean[] supplied = new boolean[adapter.attributes.length];
        for (int i = 0; i < allAttributes.length; ++i) {
            ModelClass attributeType;
            Integer index = adapter.attributeIndices.get(allAttributes[i]);
            if (index == null) continue;
            supplied[index.intValue()] = true;
            ++matchingAttributes;
            String parameterTypeStr = adapter.parameterTypes[index];
            ModelClass paramClass = this.mClassAnalyzer.findClass(parameterTypeStr, null);
            if (paramClass == null) {
                return null;
            }
            ModelClass parameterType = SetterStore.eraseType(paramClass);
            if (parameterType.isAssignableFrom(attributeType = attributeValues[i]) || ModelMethod.isBoxingConversion(parameterType, attributeType) || ModelMethod.isImplicitConversion(attributeType, parameterType)) continue;
            conversions[index.intValue()] = this.getConversionMethod(attributeType, parameterType, null);
            if (conversions[index] != null) continue;
            if (attributeType.isObject()) {
                casts[index.intValue()] = parameterTypeStr;
                continue;
            }
            return null;
        }
        if (adapter.requireAll && matchingAttributes != adapter.attributes.length || matchingAttributes == 0) {
            return null;
        }
        return new MultiAttributeSetter(adapter, supplied, method, conversions, casts);
    }

    public SetterCall getSetterCall(String attribute, ModelClass viewType, ModelClass valueType, ImportBag imports) {
        SetterCall rootViewSetter;
        if (viewType == null) {
            return null;
        }
        viewType = viewType.erasure();
        attribute = SetterStore.stripNamespace(attribute);
        class BestSetter {
            ModelClass viewType = null;
            ModelClass valueType = null;
            SetterCall setterCall = null;

            BestSetter() {
            }
        }
        BestSetter bestSetter = new BestSetter();
        ModelMethod bestSetterMethod = this.getBestSetter(viewType, valueType, attribute, imports);
        if (bestSetterMethod != null) {
            bestSetter.viewType = bestSetterMethod.getReceiverType();
            bestSetter.valueType = bestSetterMethod.getParameterTypes()[0];
            bestSetter.setterCall = new ModelMethodSetter(bestSetterMethod);
        }
        ModelClass finalViewType = viewType;
        this.mStore.forEachAdapterMethod(attribute, (Function2<? super AccessorKey, ? super MethodDescription, Unit>)((Function2)(key, adapter) -> {
            block6: {
                try {
                    ModelClass adapterViewType = this.mClassAnalyzer.findClass(key.viewType, imports).erasure();
                    if (adapterViewType == null || !adapterViewType.isAssignableFrom(finalViewType)) break block6;
                    try {
                        L.d((String)"setter parameter type is %s", (Object[])new Object[]{key.valueType});
                        ModelClass adapterValueType = SetterStore.eraseType(this.mClassAnalyzer.findClass(key.valueType, imports));
                        L.d((String)"setter %s takes type %s, compared to %s", (Object[])new Object[]{adapter.method, adapterValueType.toJavaCode(), valueType.toJavaCode()});
                        if (this.isBetterParameter(valueType, adapterViewType, adapterValueType, bestSetter.viewType, bestSetter.valueType, imports)) {
                            ModelClass adapterClass = this.mClassAnalyzer.findClass(adapter.type, imports);
                            if (adapterClass == null) {
                                L.d((String)"ignoring adapter %s because it is not in the compile classpath.", (Object[])new Object[]{adapter.type});
                                return null;
                            }
                            bestSetter.viewType = adapterViewType;
                            bestSetter.valueType = adapterValueType;
                            bestSetter.setterCall = new AdapterSetter((MethodDescription)adapter, adapterValueType);
                        }
                    }
                    catch (Exception e) {
                        L.e((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{key.valueType});
                    }
                }
                catch (Exception e) {
                    L.e((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{key.viewType});
                }
            }
            return null;
        }));
        if (bestSetter.setterCall != null) {
            if (valueType.isObject() && bestSetter.valueType.isNullable()) {
                bestSetter.setterCall.setCast(bestSetter.valueType);
            }
            MethodDescription conversionMethod = this.getConversionMethod(valueType, bestSetter.valueType, imports);
            bestSetter.setterCall.setConverter(conversionMethod);
        }
        if (bestSetter.setterCall == null && viewType.isViewDataBinding() && (rootViewSetter = this.getSetterCall(attribute, viewType.findInstanceGetter("getRoot").getReturnType(), valueType, imports)) != null) {
            return new ViewBindingRootViewSetterCall(rootViewSetter);
        }
        return bestSetter.setterCall;
    }

    public BindingGetterCall getGetterCall(String attribute, ModelClass viewType, ModelClass valueType, ImportBag imports) {
        if (viewType == null) {
            return null;
        }
        if (viewType.isViewDataBinding()) {
            return new ViewDataBindingGetterCall(viewType, attribute);
        }
        attribute = SetterStore.stripNamespace(attribute);
        viewType = viewType.erasure();
        InverseMethod bestMethod = this.getBestGetter(viewType, valueType, attribute, imports);
        ModelClass finalViewType = viewType;
        this.mStore.forEachInverseAdapterMethod(attribute, (Function2<? super AccessorKey, ? super InverseDescription, Unit>)((Function2)(key, inverseDescription) -> {
            block7: {
                try {
                    ModelClass adapterViewType = this.mClassAnalyzer.findClass(key.viewType, imports).erasure();
                    if (adapterViewType == null || !adapterViewType.isAssignableFrom(finalViewType)) break block7;
                    try {
                        L.d((String)"getter return type is %s", (Object[])new Object[]{key.valueType});
                        ModelClass adapterValueType = SetterStore.eraseType(this.mClassAnalyzer.findClass(key.valueType, imports));
                        L.d((String)"getter %s returns type %s, compared to %s", (Object[])new Object[]{inverseDescription.method, adapterValueType.toJavaCode(), valueType});
                        if (valueType != null && !this.isBetterReturn(valueType, adapterViewType, adapterValueType, bestMethod.viewType, bestMethod.returnType, imports)) break block7;
                        bestMethod.viewType = adapterViewType;
                        bestMethod.returnType = adapterValueType;
                        ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
                        ModelClass listenerType = modelAnalyzer.findClass(modelAnalyzer.libTypes.getInverseBindingListener(), ImportBag.EMPTY);
                        SetterCall eventCall = this.getSetterCall(inverseDescription.event, finalViewType, listenerType, imports);
                        if (eventCall == null) {
                            List<MultiAttributeSetter> setters = this.getMultiAttributeSetterCalls(new String[]{inverseDescription.event}, finalViewType, new ModelClass[]{listenerType});
                            if (setters.size() != 1) {
                                L.e((String)"Could not find event '%s' on View type '%s'", (Object[])new Object[]{inverseDescription.event, finalViewType.getCanonicalName()});
                            } else {
                                bestMethod.call = new AdapterGetter((InverseDescription)inverseDescription, setters.get(0), key.valueType);
                            }
                            break block7;
                        }
                        bestMethod.call = new AdapterGetter((InverseDescription)inverseDescription, eventCall, key.valueType);
                    }
                    catch (Exception e) {
                        L.e((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{key.valueType});
                    }
                }
                catch (Exception e) {
                    L.e((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{key.viewType});
                }
            }
            return null;
        }));
        return bestMethod.call;
    }

    public String getInverseMethod(ModelMethod method) {
        InverseMethodDescription description = new InverseMethodDescription(method);
        return this.mStore.getInverseMethod(description);
    }

    public boolean isUntaggable(String viewType) {
        return this.mStore.isUntaggable(viewType);
    }

    private ModelMethod getBestSetter(ModelClass viewType, ModelClass argumentType, String attribute, ImportBag imports) {
        if (viewType.isGeneric()) {
            argumentType = SetterStore.eraseType(argumentType, viewType.getTypeArguments());
            viewType = viewType.erasure();
        }
        ModelClass finalViewType = viewType;
        List<String> setterCandidates = this.mStore.findRenamed(attribute, (Function1<? super String, Boolean>)((Function1)className -> {
            try {
                ModelClass renamedViewType = this.mClassAnalyzer.findClass((String)className, imports);
                if (renamedViewType == null) {
                    return false;
                }
                return renamedViewType.erasure().isAssignableFrom(finalViewType);
            }
            catch (Exception exception) {
                return false;
            }
        }));
        setterCandidates.add(SetterStore.getSetterName(attribute));
        setterCandidates.add(SetterStore.trimAttributeNamespace(attribute));
        ModelMethod bestMethod = null;
        ModelClass bestParameterType = null;
        ArrayList<ModelClass> args2 = new ArrayList<ModelClass>();
        args2.add(argumentType);
        for (String name : setterCandidates) {
            List<ModelMethod> methods = viewType.getMethods(name, 1);
            for (ModelMethod method : methods) {
                ModelClass previousViewType;
                ModelClass[] parameterTypes = method.getParameterTypes();
                ModelClass param = parameterTypes[0];
                ModelClass modelClass = previousViewType = bestParameterType == null ? null : viewType;
                if (!method.isVoid() || !this.isBetterParameter(argumentType, viewType, param, previousViewType, bestParameterType, imports)) continue;
                bestParameterType = param;
                bestMethod = method;
            }
        }
        return bestMethod;
    }

    private InverseMethod getBestGetter(ModelClass viewType, ModelClass valueType, String attribute, ImportBag imports) {
        if (viewType.isGeneric()) {
            if (valueType != null) {
                valueType = SetterStore.eraseType(valueType, viewType.getTypeArguments());
            }
            viewType = viewType.erasure();
        }
        class BestSetter {
            ModelClass returnType = null;
            InverseDescription description = null;
            ModelClass viewType = null;
            ModelMethod method = null;

            BestSetter() {
            }
        }
        BestSetter bestSetter = new BestSetter();
        ModelClass finalViewType = viewType;
        ModelClass finalValueType = valueType;
        this.mStore.forEachInverseMethod(attribute, (Function2<? super String, ? super InverseDescription, Unit>)((Function2)(className, inverseDescription) -> {
            try {
                ModelClass methodViewType = this.mClassAnalyzer.findClass((String)className, imports);
                if (methodViewType != null && methodViewType.erasure().isAssignableFrom(finalViewType)) {
                    String name = inverseDescription.method.isEmpty() ? SetterStore.trimAttributeNamespace(attribute) : inverseDescription.method;
                    ModelMethod method = methodViewType.findInstanceGetter(name);
                    ModelClass returnType = method.getReturnType(null);
                    if (finalValueType == null || bestSetter.returnType == null || this.isBetterReturn(finalValueType, methodViewType, returnType, bestSetter.viewType, bestSetter.returnType, imports)) {
                        bestSetter.description = inverseDescription;
                        bestSetter.returnType = returnType;
                        bestSetter.viewType = methodViewType;
                        bestSetter.method = method;
                    }
                }
            }
            catch (Exception e) {
                L.d((Throwable)e, (String)("Unknown class: " + className), (Object[])new Object[0]);
            }
            return null;
        }));
        ViewGetterCall call = null;
        if (bestSetter.description != null) {
            ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
            ModelClass listenerType = modelAnalyzer.findClass(modelAnalyzer.libTypes.getInverseBindingListener(), ImportBag.EMPTY);
            SetterCall eventSetter = this.getSetterCall(bestSetter.description.event, viewType, listenerType, imports);
            if (eventSetter == null) {
                List<MultiAttributeSetter> setters = this.getMultiAttributeSetterCalls(new String[]{bestSetter.description.event}, viewType, new ModelClass[]{listenerType});
                if (setters.size() != 1) {
                    L.e((String)"Could not find event '%s' on View type '%s'", (Object[])new Object[]{bestSetter.description.event, viewType.getCanonicalName()});
                    bestSetter.viewType = null;
                    bestSetter.returnType = null;
                } else {
                    call = new ViewGetterCall(bestSetter.description, bestSetter.method, setters.get(0));
                }
            } else {
                call = new ViewGetterCall(bestSetter.description, bestSetter.method, eventSetter);
            }
        }
        return new InverseMethod(call, bestSetter.returnType, bestSetter.viewType);
    }

    private static ModelClass eraseType(ModelClass type, List<ModelClass> typeParameters) {
        List<ModelClass> typeArguments2 = type.getTypeArguments();
        if (typeArguments2 == null || typeParameters == null) {
            return type;
        }
        for (ModelClass arg : typeArguments2) {
            if (!typeParameters.contains(arg)) continue;
            return type.erasure();
        }
        return type;
    }

    private static String trimAttributeNamespace(String attribute) {
        int colonIndex = attribute.indexOf(58);
        return colonIndex == -1 ? attribute : attribute.substring(colonIndex + 1);
    }

    private static String getSetterName(String attribute) {
        return "set" + StringUtils.capitalize((String)SetterStore.trimAttributeNamespace(attribute));
    }

    private boolean isBetterParameter(ModelClass argument, ModelClass newViewType, ModelClass newParameter, ModelClass oldViewType, ModelClass oldParameter, ImportBag imports) {
        if (oldParameter == null) {
            return this.calculateConversionPriority(argument, newParameter, imports) >= 0;
        }
        int newConversion = this.calculateConversionPriority(argument, newParameter, imports);
        if (newConversion < 0) {
            return false;
        }
        boolean isSameViewType = oldViewType.equals(newViewType);
        boolean isBetterViewType = oldViewType.isAssignableFrom(newViewType);
        int oldConversion = this.calculateConversionPriority(argument, oldParameter, imports);
        if (oldConversion == 1 && newConversion == 1) {
            if (isSameViewType) {
                return oldParameter.isAssignableFrom(newParameter);
            }
            return isBetterViewType;
        }
        if (isSameViewType) {
            return newConversion <= oldConversion;
        }
        if (newConversion == oldConversion) {
            return isBetterViewType;
        }
        return newConversion <= oldConversion;
    }

    private boolean isBetterReturn(ModelClass expected, ModelClass newViewType, ModelClass newReturnType, ModelClass oldViewType, ModelClass oldReturnType, ImportBag imports) {
        if (oldReturnType == null) {
            return this.calculateConversionPriority(newReturnType, expected, imports) >= 0;
        }
        int newConversion = this.calculateConversionPriority(newReturnType, expected, imports);
        if (newConversion < 0) {
            return false;
        }
        boolean isSameViewType = oldViewType.equals(newViewType);
        boolean isBetterViewType = oldViewType.isAssignableFrom(newViewType);
        int oldConversion = this.calculateConversionPriority(oldReturnType, expected, imports);
        if (oldConversion == 1 && newConversion == 1) {
            if (isSameViewType) {
                return newReturnType.isAssignableFrom(oldReturnType);
            }
            return isBetterViewType;
        }
        if (isSameViewType) {
            return newConversion <= oldConversion;
        }
        if (newConversion == oldConversion) {
            return isBetterViewType;
        }
        return newConversion <= oldConversion;
    }

    private int calculateConversionPriority(ModelClass from, ModelClass to, ImportBag imports) {
        if (to.equals(from)) {
            return 0;
        }
        if (to.isAssignableFrom(from)) {
            return 1;
        }
        if (ModelMethod.isBoxingConversion(from, to)) {
            return 2;
        }
        if (ModelMethod.isImplicitConversion(from, to)) {
            return 3 + ModelMethod.getImplicitConversionLevel(to);
        }
        if (this.getConversionMethod(from, to, imports) != null) {
            return 10;
        }
        if (from.isObject() && !to.isPrimitive()) {
            return 11;
        }
        return -1;
    }

    private MethodDescription getConversionMethod(ModelClass from, ModelClass to, ImportBag imports) {
        if (from != null && to != null) {
            if (to.isObject()) {
                return null;
            }
            return this.mStore.findFirstConversionMethod((Function2<? super String, ? super Map<String, ? extends MethodDescription>, ? extends MethodDescription>)((Function2)(fromClassName, conversion) -> {
                try {
                    ModelClass convertFrom = this.mClassAnalyzer.findClass((String)fromClassName, imports);
                    if (convertFrom != null && this.canUseForConversion(from, convertFrom)) {
                        for (String toClassName : conversion.keySet()) {
                            try {
                                ModelClass convertTo = this.mClassAnalyzer.findClass(toClassName, imports);
                                if (convertTo == null || !this.canUseForConversion(convertTo, to)) continue;
                                return (MethodDescription)conversion.get(toClassName);
                            }
                            catch (Exception e) {
                                L.d((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{toClassName});
                            }
                        }
                    }
                }
                catch (Exception e) {
                    L.d((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{fromClassName});
                }
                return null;
            }));
        }
        return null;
    }

    private boolean canUseForConversion(ModelClass from, ModelClass to) {
        if (from.isIncomplete() || to.isIncomplete()) {
            from = from.erasure();
            to = to.erasure();
        }
        return from.equals(to) || ModelMethod.isBoxingConversion(from, to) || to.isAssignableFrom(from);
    }

    private static String createAdapterCall(MethodDescription adapter, String componentExpression, String viewExpression, String ... args2) {
        StringBuilder sb = new StringBuilder();
        if (adapter.isStatic) {
            sb.append(adapter.type);
        } else {
            SetterStore setterStore = SetterStore.get();
            String binderCall = setterStore.getBindingAdapterCall(adapter.type);
            sb.append(componentExpression).append('.').append(binderCall);
        }
        sb.append('.').append(adapter.method).append('(');
        if (adapter.componentClass != null) {
            if (!"DataBindingComponent".equals(adapter.componentClass)) {
                sb.append('(').append(adapter.componentClass).append(") ");
            }
            sb.append(componentExpression).append(", ");
        }
        sb.append(viewExpression);
        for (String arg : args2) {
            sb.append(", ").append(arg);
        }
        sb.append(')');
        return sb.toString();
    }

    private static int nullableCompare(Comparable o1, Comparable o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    private static int stringArrayCompare(String[] array1, String[] array2) {
        if (array1 == null) {
            if (array2 == null) {
                return 0;
            }
            return 1;
        }
        if (array2 == null) {
            return -1;
        }
        int lengthCmp = Integer.compare(array1.length, array2.length);
        if (lengthCmp != 0) {
            return lengthCmp;
        }
        for (int i = 0; i < array1.length; ++i) {
            int itemCmp = SetterStore.nullableCompare((Comparable)((Object)array1[i]), (Comparable)((Object)array2[i]));
            if (itemCmp == 0) continue;
            return itemCmp;
        }
        return 0;
    }

    private static int mergedHashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    private static class ViewBindingRootViewSetterCall
    extends SetterCall {
        private final SetterCall mWrapped;

        public ViewBindingRootViewSetterCall(SetterCall wrapped) {
            this.mWrapped = wrapped;
        }

        @Override
        public boolean requiresOldValue() {
            return this.mWrapped.requiresOldValue();
        }

        @Override
        public ModelClass[] getParameterTypes() {
            return this.mWrapped.getParameterTypes();
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return this.mWrapped.getBindingAdapterInstanceClass();
        }

        @Override
        public String getDescription() {
            return this.mWrapped.getDescription();
        }

        @Override
        protected String toJavaInternal(String componentExpression, String viewExpression, String converted) {
            return this.mWrapped.toJavaInternal(componentExpression, viewExpression + ".getRoot()", converted);
        }

        @Override
        protected String toJavaInternal(String componentExpression, String viewExpression, String oldValue, String converted) {
            return this.mWrapped.toJavaInternal(componentExpression, viewExpression + ".getRoot()", oldValue, converted);
        }

        @Override
        public int getMinApi() {
            return this.mWrapped.getMinApi();
        }
    }

    private static class InverseMethod {
        public BindingGetterCall call;
        public ModelClass returnType;
        public ModelClass viewType;

        public InverseMethod(BindingGetterCall call, ModelClass returnType, ModelClass viewType) {
            this.call = call;
            this.returnType = returnType;
            this.viewType = viewType;
        }
    }

    public static class AdapterGetter
    implements BindingGetterCall {
        private final InverseDescription mInverseDescription;
        private String mBindingAdapterCall;
        private final BindingSetterCall mEventCall;
        private final String mGetterType;

        public AdapterGetter(InverseDescription description, BindingSetterCall eventCall, String getterType) {
            this.mInverseDescription = description;
            this.mEventCall = eventCall;
            this.mGetterType = getterType;
        }

        @Override
        public String getGetterType() {
            return this.mGetterType;
        }

        @Override
        public String toJava(String componentExpression, String viewExpression) {
            StringBuilder sb = new StringBuilder();
            if (this.mInverseDescription.isStatic) {
                sb.append(this.mInverseDescription.type);
            } else {
                sb.append(componentExpression).append('.').append(this.mBindingAdapterCall);
            }
            sb.append('.').append(this.mInverseDescription.method).append('(');
            if (this.mInverseDescription.componentClass != null) {
                if (!"DataBindingComponent".equals(this.mInverseDescription.componentClass)) {
                    sb.append('(').append(this.mInverseDescription.componentClass).append(") ");
                }
                sb.append(componentExpression).append(", ");
            }
            sb.append(viewExpression).append(')');
            return sb.toString();
        }

        @Override
        public int getMinApi() {
            return 1;
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return this.mInverseDescription.isStatic ? null : this.mInverseDescription.type;
        }

        @Override
        public void setBindingAdapterCall(String method) {
            this.mBindingAdapterCall = method;
        }

        @Override
        public BindingSetterCall getEvent() {
            return this.mEventCall;
        }

        @Override
        public String getEventAttribute() {
            return this.mInverseDescription.event;
        }
    }

    public static class ViewGetterCall
    implements BindingGetterCall {
        private final InverseDescription mInverseDescription;
        private final BindingSetterCall mEventCall;
        private final ModelMethod mMethod;

        public ViewGetterCall(InverseDescription inverseDescription, ModelMethod method, BindingSetterCall eventCall) {
            this.mInverseDescription = inverseDescription;
            this.mEventCall = eventCall;
            this.mMethod = method;
        }

        @Override
        public BindingSetterCall getEvent() {
            return this.mEventCall;
        }

        @Override
        public String getEventAttribute() {
            return this.mInverseDescription.event;
        }

        @Override
        public String toJava(String componentExpression, String viewExpression) {
            return viewExpression + "." + this.mMethod.getName() + "()";
        }

        @Override
        public String getGetterType() {
            return this.mMethod.getReturnType().toJavaCode();
        }

        @Override
        public int getMinApi() {
            return this.mMethod.getMinApi();
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return null;
        }

        @Override
        public void setBindingAdapterCall(String method) {
        }
    }

    public static class ViewDataBindingGetterCall
    implements BindingGetterCall {
        private final String mGetter;
        private final BindingSetterCall mEventSetter;
        private final String mAttribute;
        private final ModelClass mBindingClass;

        public ViewDataBindingGetterCall(ModelClass bindingClass, String attribute) {
            int colonIndex = attribute.indexOf(58);
            this.mAttribute = attribute.substring(colonIndex + 1);
            this.mGetter = "get" + StringUtils.capitalize((String)this.mAttribute);
            this.mEventSetter = new ViewDataBindingEventSetter();
            this.mBindingClass = bindingClass;
        }

        @Override
        public String toJava(String componentExpression, String viewExpression) {
            return viewExpression + "." + this.mGetter + "()";
        }

        @Override
        public String getGetterType() {
            return this.mBindingClass.findInstanceGetter(this.mGetter).getReturnType().toJavaCode();
        }

        @Override
        public int getMinApi() {
            return 0;
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return null;
        }

        @Override
        public void setBindingAdapterCall(String method) {
        }

        @Override
        public BindingSetterCall getEvent() {
            return this.mEventSetter;
        }

        @Override
        public String getEventAttribute() {
            return this.mAttribute;
        }
    }

    public static interface BindingGetterCall {
        public String toJava(String var1, String var2);

        public String getGetterType();

        public int getMinApi();

        public String getBindingAdapterInstanceClass();

        public void setBindingAdapterCall(String var1);

        public BindingSetterCall getEvent();

        public String getEventAttribute();
    }

    public static class ViewDataBindingEventSetter
    implements BindingSetterCall {
        @Override
        public String toJava(String componentExpression, String viewExpression, String ... valueExpressions) {
            return "setBindingInverseListener(" + viewExpression + ", " + valueExpressions[0] + ", " + valueExpressions[1] + ")";
        }

        @Override
        public int getMinApi() {
            return 0;
        }

        @Override
        public boolean requiresOldValue() {
            return true;
        }

        @Override
        public ModelClass[] getParameterTypes() {
            ModelClass[] parameterTypes = new ModelClass[]{ModelAnalyzer.getInstance().findClass("android.databinding.ViewDataBinder.PropertyChangedInverseListener", null)};
            return parameterTypes;
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return null;
        }

        @Override
        public String getDescription() {
            return "ViewDataBinding.setBindingInverseListener";
        }
    }

    public static class MultiAttributeSetter
    implements BindingSetterCall {
        public final String[] attributes;
        private final MethodDescription mAdapter;
        private final MethodDescription[] mConverters;
        private final String[] mCasts;
        private final MultiValueAdapterKey mKey;
        private final boolean[] mSupplied;

        public MultiAttributeSetter(MultiValueAdapterKey key, boolean[] supplied, MethodDescription adapter, MethodDescription[] converters, String[] casts) {
            Preconditions.check((converters != null && converters.length == key.attributes.length && casts != null && casts.length == key.attributes.length && supplied.length == key.attributes.length ? 1 : 0) != 0, (String)"invalid arguments to create multi attr setter", (Object[])new Object[0]);
            this.mAdapter = adapter;
            this.mConverters = converters;
            this.mCasts = casts;
            this.mKey = key;
            this.mSupplied = supplied;
            if (key.requireAll) {
                this.attributes = key.attributes;
            } else {
                int numSupplied = 0;
                for (int i = 0; i < this.mKey.attributes.length; ++i) {
                    if (!supplied[i]) continue;
                    ++numSupplied;
                }
                if (numSupplied == key.attributes.length) {
                    this.attributes = key.attributes;
                } else {
                    this.attributes = new String[numSupplied];
                    int attrIndex = 0;
                    for (int i = 0; i < key.attributes.length; ++i) {
                        if (!supplied[i]) continue;
                        this.attributes[attrIndex++] = key.attributes[i];
                    }
                }
            }
        }

        @Override
        public final String toJava(String componentExpression, String viewExpression, String ... valueExpressions) {
            Preconditions.check((valueExpressions.length == this.attributes.length * 2 ? 1 : 0) != 0, (String)"MultiAttributeSetter needs %s items, received %s", (Object[])new Object[]{Arrays.toString(this.attributes), Arrays.toString(valueExpressions)});
            int numAttrs = this.mKey.attributes.length;
            String[] args2 = new String[numAttrs + (this.requiresOldValue() ? numAttrs : 0)];
            int startIndex = this.mAdapter.requiresOldValue ? 0 : numAttrs;
            int attrIndex = this.mAdapter.requiresOldValue ? 0 : this.attributes.length;
            ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
            StringBuilder argBuilder = new StringBuilder();
            int endIndex = numAttrs * 2;
            for (int i = startIndex; i < endIndex; ++i) {
                argBuilder.setLength(0);
                if (!this.mSupplied[i % numAttrs]) {
                    String paramType = this.mKey.parameterTypes[i % numAttrs];
                    String defaultValue = modelAnalyzer.getDefaultValue(paramType);
                    argBuilder.append('(').append(paramType).append(')').append(defaultValue);
                } else {
                    if (this.mConverters[i % numAttrs] != null) {
                        MethodDescription converter = this.mConverters[i % numAttrs];
                        argBuilder.append(converter.type).append('.').append(converter.method).append('(').append(valueExpressions[attrIndex]).append(')');
                    } else {
                        if (this.mCasts[i % numAttrs] != null) {
                            argBuilder.append('(').append(this.mCasts[i % numAttrs]).append(')');
                        }
                        argBuilder.append(valueExpressions[attrIndex]);
                    }
                    ++attrIndex;
                }
                args2[i - startIndex] = argBuilder.toString();
            }
            return SetterStore.createAdapterCall(this.mAdapter, componentExpression, viewExpression, args2);
        }

        @Override
        public int getMinApi() {
            return 1;
        }

        @Override
        public boolean requiresOldValue() {
            return this.mAdapter.requiresOldValue;
        }

        @Override
        public ModelClass[] getParameterTypes() {
            ModelClass[] parameters = new ModelClass[this.attributes.length];
            String[] paramTypeStrings = this.mKey.parameterTypes;
            ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
            int attrIndex = 0;
            for (int i = 0; i < this.mKey.attributes.length; ++i) {
                if (!this.mSupplied[i]) continue;
                parameters[attrIndex++] = modelAnalyzer.findClass(paramTypeStrings[i], null);
            }
            return parameters;
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return this.mAdapter.isStatic ? null : this.mAdapter.type;
        }

        public String toString() {
            return "MultiAttributeSetter{attributes=" + Arrays.toString(this.attributes) + ", mAdapter=" + this.mAdapter + ", mConverters=" + Arrays.toString(this.mConverters) + ", mCasts=" + Arrays.toString(this.mCasts) + ", mKey=" + this.mKey + '}';
        }

        @Override
        public String getDescription() {
            return this.mAdapter.type + "." + this.mAdapter.method;
        }
    }

    public static abstract class SetterCall
    implements BindingSetterCall {
        private MethodDescription mConverter;
        protected String mCastString = "";

        public void setConverter(MethodDescription converter) {
            this.mConverter = converter;
        }

        protected abstract String toJavaInternal(String var1, String var2, String var3);

        protected abstract String toJavaInternal(String var1, String var2, String var3, String var4);

        @Override
        public final String toJava(String componentExpression, String viewExpression, String ... valueExpression) {
            Preconditions.check((valueExpression.length == 2 ? 1 : 0) != 0, (String)"value expressions size must be 2", (Object[])new Object[0]);
            if (this.requiresOldValue()) {
                return this.toJavaInternal(componentExpression, viewExpression, this.convertValue(valueExpression[0]), this.convertValue(valueExpression[1]));
            }
            return this.toJavaInternal(componentExpression, viewExpression, this.convertValue(valueExpression[1]));
        }

        protected String convertValue(String valueExpression) {
            return this.mConverter == null ? valueExpression : this.mConverter.type + "." + this.mConverter.method + "(" + valueExpression + ")";
        }

        @Override
        public abstract int getMinApi();

        public void setCast(ModelClass castTo) {
            this.mCastString = "(" + castTo.toJavaCode() + ") ";
        }
    }

    public static interface BindingSetterCall {
        public String toJava(String var1, String var2, String ... var3);

        public int getMinApi();

        public boolean requiresOldValue();

        public ModelClass[] getParameterTypes();

        public String getBindingAdapterInstanceClass();

        public String getDescription();
    }

    public static class ModelMethodSetter
    extends SetterCall {
        final ModelMethod mModelMethod;

        public ModelMethodSetter(ModelMethod modelMethod) {
            this.mModelMethod = modelMethod;
        }

        @Override
        public String toJavaInternal(String componentExpression, String viewExpression, String valueExpression) {
            return viewExpression + "." + this.mModelMethod.getName() + "(" + this.mCastString + valueExpression + ")";
        }

        @Override
        protected String toJavaInternal(String componentExpression, String viewExpression, String oldValue, String valueExpression) {
            return viewExpression + "." + this.mModelMethod.getName() + "(" + this.mCastString + oldValue + ", " + this.mCastString + valueExpression + ")";
        }

        @Override
        public int getMinApi() {
            return this.mModelMethod.getMinApi();
        }

        @Override
        public boolean requiresOldValue() {
            return this.mModelMethod.getParameterTypes().length == 3;
        }

        @Override
        public ModelClass[] getParameterTypes() {
            return new ModelClass[]{this.mModelMethod.getParameterTypes()[0]};
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return null;
        }

        @Override
        public String getDescription() {
            String args2 = Arrays.stream(this.mModelMethod.getParameterTypes()).map(param -> param.toJavaCode()).collect(Collectors.joining(", "));
            return this.mModelMethod.getReceiverType().toJavaCode() + '.' + this.mModelMethod.getName() + '(' + args2 + ')';
        }
    }

    public static class AdapterSetter
    extends SetterCall {
        final MethodDescription mAdapter;
        final ModelClass mParameterType;

        public AdapterSetter(MethodDescription adapter, ModelClass parameterType) {
            this.mAdapter = adapter;
            this.mParameterType = parameterType;
        }

        @Override
        public String toJavaInternal(String componentExpression, String viewExpression, String valueExpression) {
            return SetterStore.createAdapterCall(this.mAdapter, componentExpression, viewExpression, new String[]{this.mCastString + valueExpression});
        }

        @Override
        protected String toJavaInternal(String componentExpression, String viewExpression, String oldValue, String valueExpression) {
            return SetterStore.createAdapterCall(this.mAdapter, componentExpression, viewExpression, new String[]{this.mCastString + oldValue, this.mCastString + valueExpression});
        }

        @Override
        public int getMinApi() {
            return 1;
        }

        @Override
        public boolean requiresOldValue() {
            return this.mAdapter.requiresOldValue;
        }

        @Override
        public ModelClass[] getParameterTypes() {
            return new ModelClass[]{this.mParameterType};
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return this.mAdapter.isStatic ? null : this.mAdapter.type;
        }

        @Override
        public String getDescription() {
            return this.mAdapter.type + "." + this.mAdapter.method;
        }
    }

    public static class IntermediateV3
    extends IntermediateV2 {
        private static final long serialVersionUID = 3072L;
        public final HashMap<InverseMethodDescription, String> twoWayMethods = new HashMap();

        @Override
        public Intermediate upgrade() {
            return new BindingAdapterStore(this);
        }
    }

    private static class IntermediateV2
    extends IntermediateV1 {
        private static final long serialVersionUID = -6603351593475417081L;
        public final HashMap<String, HashMap<AccessorKey, InverseDescription>> inverseAdapters = new HashMap();
        public final HashMap<String, HashMap<String, InverseDescription>> inverseMethods = new HashMap();

        private IntermediateV2() {
        }

        @Override
        public Intermediate upgrade() {
            IntermediateV3 v3 = new IntermediateV3();
            v3.adapterMethods.putAll(this.adapterMethods);
            v3.renamedMethods.putAll(this.renamedMethods);
            v3.conversionMethods.putAll(this.conversionMethods);
            v3.untaggableTypes.putAll(this.untaggableTypes);
            v3.multiValueAdapters.putAll(this.multiValueAdapters);
            v3.inverseAdapters.putAll(this.inverseAdapters);
            v3.inverseMethods.putAll(this.inverseMethods);
            return v3.upgrade();
        }
    }

    private static class IntermediateV1
    implements Serializable,
    Intermediate {
        private static final long serialVersionUID = 1L;
        public final HashMap<String, HashMap<AccessorKey, MethodDescription>> adapterMethods = new HashMap();
        public final HashMap<String, HashMap<String, MethodDescription>> renamedMethods = new HashMap();
        public final HashMap<String, HashMap<String, MethodDescription>> conversionMethods = new HashMap();
        public final HashMap<String, String> untaggableTypes = new HashMap();
        public final HashMap<MultiValueAdapterKey, MethodDescription> multiValueAdapters = new HashMap();

        @Override
        public Intermediate upgrade() {
            IntermediateV2 v2 = new IntermediateV2();
            v2.adapterMethods.putAll(this.adapterMethods);
            v2.renamedMethods.putAll(this.renamedMethods);
            v2.conversionMethods.putAll(this.conversionMethods);
            v2.untaggableTypes.putAll(this.untaggableTypes);
            v2.multiValueAdapters.putAll(this.multiValueAdapters);
            return v2.upgrade();
        }
    }

    static interface Intermediate
    extends Serializable {
        public Intermediate upgrade();
    }

    static class InverseMethodDescription
    implements Serializable,
    Comparable<InverseMethodDescription> {
        private static final long serialVersionUID = 3072L;
        public final boolean isStatic;
        public final String returnType;
        public final String method;
        public final String[] parameterTypes;
        public final String type;

        public InverseMethodDescription(ProcessingEnvironment env, ExecutableElement method) {
            this.isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
            Types typeUtils = env.getTypeUtils();
            this.returnType = SetterStore.getQualifiedName(typeUtils.erasure(method.getReturnType()));
            this.method = method.getSimpleName().toString();
            TypeElement enclosingClass = (TypeElement)method.getEnclosingElement();
            this.type = enclosingClass.getQualifiedName().toString();
            List<? extends VariableElement> parameters = method.getParameters();
            this.parameterTypes = new String[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement param = parameters.get(i);
                TypeMirror type = typeUtils.erasure(param.asType());
                this.parameterTypes[i] = SetterStore.getQualifiedName(type);
            }
        }

        public InverseMethodDescription(ModelMethod method) {
            this.isStatic = method.isStatic();
            this.returnType = method.getReturnType().erasure().getCanonicalName();
            this.method = method.getName();
            this.type = method.getReceiverType().getCanonicalName();
            ModelClass[] parameters = method.getParameterTypes();
            this.parameterTypes = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                this.parameterTypes[i] = parameters[i].erasure().getCanonicalName();
            }
        }

        public int hashCode() {
            return SetterStore.mergedHashCode(new Object[]{this.type, this.isStatic, this.returnType, this.method, Arrays.hashCode(this.parameterTypes)});
        }

        public boolean equals(Object obj) {
            if (obj instanceof InverseMethodDescription) {
                InverseMethodDescription that = (InverseMethodDescription)obj;
                return this.isStatic == that.isStatic && this.type.equals(that.type) && this.returnType.equals(that.returnType) && this.method.equals(that.method) && Arrays.equals(this.parameterTypes, that.parameterTypes);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.isStatic) {
                sb.append("static ");
            }
            sb.append(this.returnType).append(' ').append(this.type).append('.').append(this.method).append('(');
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.parameterTypes[i]);
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        public int compareTo(InverseMethodDescription other) {
            int staticCmp = Boolean.compare(this.isStatic, other.isStatic);
            if (staticCmp != 0) {
                return staticCmp;
            }
            int returnCmp = SetterStore.nullableCompare((Comparable)((Object)this.returnType), (Comparable)((Object)other.returnType));
            if (returnCmp != 0) {
                return returnCmp;
            }
            int methodCmp = SetterStore.nullableCompare((Comparable)((Object)this.method), (Comparable)((Object)other.method));
            if (methodCmp != 0) {
                return methodCmp;
            }
            int paramCmp = SetterStore.stringArrayCompare(this.parameterTypes, other.parameterTypes);
            if (paramCmp != 0) {
                return paramCmp;
            }
            return SetterStore.nullableCompare((Comparable)((Object)this.type), (Comparable)((Object)other.type));
        }
    }

    static class AccessorKey
    implements Serializable,
    Comparable<AccessorKey> {
        private static final long serialVersionUID = 1L;
        public final String viewType;
        public final String valueType;

        public AccessorKey(String viewType, String valueType) {
            this.viewType = viewType;
            this.valueType = valueType;
        }

        public int hashCode() {
            return SetterStore.mergedHashCode(new Object[]{this.viewType, this.valueType});
        }

        public boolean equals(Object obj) {
            if (obj instanceof AccessorKey) {
                AccessorKey that = (AccessorKey)obj;
                return this.viewType.equals(that.viewType) && this.valueType.equals(that.valueType);
            }
            return false;
        }

        public String toString() {
            return "AK(" + this.viewType + ", " + this.valueType + ")";
        }

        @Override
        public int compareTo(AccessorKey other) {
            int viewTypeCmp = SetterStore.nullableCompare((Comparable)((Object)this.viewType), (Comparable)((Object)other.viewType));
            if (viewTypeCmp == 0) {
                return SetterStore.nullableCompare((Comparable)((Object)this.valueType), (Comparable)((Object)other.valueType));
            }
            return viewTypeCmp;
        }
    }

    static class InverseDescription
    extends MethodDescription {
        private static final long serialVersionUID = 1L;
        public final String event;

        public InverseDescription(String type, String method, String event) {
            super(type, method);
            this.event = event;
        }

        public InverseDescription(ExecutableElement method, String event, boolean takesComponent) {
            super(method, 1, takesComponent);
            this.event = event;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InverseDescription)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InverseDescription that = (InverseDescription)o;
            return Objects.equals(this.event, that.event);
        }

        @Override
        public String toString() {
            return this.type + "#" + this.method;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.event);
        }

        @Override
        public int compareTo(MethodDescription other) {
            int eventCmp;
            if (other instanceof InverseDescription && (eventCmp = SetterStore.nullableCompare((Comparable)((Object)this.event), (Comparable)((Object)((InverseDescription)other).event))) != 0) {
                return eventCmp;
            }
            return super.compareTo(other);
        }
    }

    static class MethodDescription
    implements Serializable,
    Comparable<MethodDescription> {
        private static final long serialVersionUID = 1L;
        public final String type;
        public final String method;
        public final boolean requiresOldValue;
        public final boolean isStatic;
        public final String componentClass;

        public MethodDescription(String type, String method) {
            this.type = type;
            this.method = method;
            this.requiresOldValue = false;
            this.isStatic = true;
            this.componentClass = null;
            L.d((String)"BINARY created method desc 1 %s %s", (Object[])new Object[]{type, method});
        }

        public MethodDescription(ExecutableElement method, int numAttributes, boolean takesComponent) {
            TypeElement enclosingClass = (TypeElement)method.getEnclosingElement();
            this.type = enclosingClass.getQualifiedName().toString();
            this.method = method.getSimpleName().toString();
            int argStart = 1 + (takesComponent ? 1 : 0);
            this.requiresOldValue = method.getParameters().size() - argStart == numAttributes * 2;
            this.isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
            this.componentClass = takesComponent ? SetterStore.getQualifiedName(method.getParameters().get(0).asType()) : null;
            L.d((String)"BINARY created method desc 2 %s %s, %s", (Object[])new Object[]{this.type, this.method, method});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodDescription)) {
                return false;
            }
            MethodDescription that = (MethodDescription)o;
            return this.requiresOldValue == that.requiresOldValue && this.isStatic == that.isStatic && Objects.equals(this.type, that.type) && Objects.equals(this.method, that.method) && Objects.equals(this.componentClass, that.componentClass);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.method, this.requiresOldValue, this.isStatic, this.componentClass);
        }

        public String toString() {
            return this.type + "#" + this.method;
        }

        @Override
        public int compareTo(MethodDescription other) {
            int typeCmp = SetterStore.nullableCompare((Comparable)((Object)this.type), (Comparable)((Object)other.type));
            if (typeCmp != 0) {
                return typeCmp;
            }
            int methodCmp = SetterStore.nullableCompare((Comparable)((Object)this.method), (Comparable)((Object)other.method));
            if (methodCmp != 0) {
                return methodCmp;
            }
            int oldValueCmp = Boolean.compare(this.requiresOldValue, other.requiresOldValue);
            if (oldValueCmp != 0) {
                return oldValueCmp;
            }
            int staticCmp = Boolean.compare(this.isStatic, other.isStatic);
            if (staticCmp != 0) {
                return staticCmp;
            }
            return SetterStore.nullableCompare((Comparable)((Object)this.componentClass), (Comparable)((Object)other.componentClass));
        }
    }

    static class MultiValueAdapterKey
    implements Serializable,
    Comparable<MultiValueAdapterKey> {
        private static final long serialVersionUID = 1L;
        public final String viewType;
        public final String[] attributes;
        public final String[] parameterTypes;
        public final boolean requireAll;
        public final TreeMap<String, Integer> attributeIndices = new TreeMap();

        public MultiValueAdapterKey(ProcessingEnvironment processingEnv, ExecutableElement method, String[] attributes, boolean takesComponent, boolean requireAll) {
            this.attributes = SetterStore.stripAttributes(attributes);
            this.requireAll = requireAll;
            List<? extends VariableElement> parameters = method.getParameters();
            int argStart = 1 + (takesComponent ? 1 : 0);
            this.viewType = SetterStore.getQualifiedName(SetterStore.eraseType(processingEnv, parameters.get(argStart - 1).asType()));
            this.parameterTypes = new String[attributes.length];
            for (int i = 0; i < attributes.length; ++i) {
                TypeMirror typeMirror = SetterStore.eraseType(processingEnv, parameters.get(i + argStart).asType());
                this.parameterTypes[i] = SetterStore.getQualifiedName(typeMirror);
                this.attributeIndices.put(this.attributes[i], i);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MultiValueAdapterKey)) {
                return false;
            }
            MultiValueAdapterKey that = (MultiValueAdapterKey)obj;
            if (!this.viewType.equals(that.viewType) || this.attributes.length != that.attributes.length || !this.attributeIndices.keySet().equals(that.attributeIndices.keySet())) {
                return false;
            }
            for (int i = 0; i < this.attributes.length; ++i) {
                String thisParameter = this.parameterTypes[i];
                int thatIndex = that.attributeIndices.get(this.attributes[i]);
                String thatParameter = that.parameterTypes[thatIndex];
                if (thisParameter.equals(thatParameter)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return SetterStore.mergedHashCode(new Object[]{this.viewType, this.attributeIndices.keySet()});
        }

        @Override
        public int compareTo(MultiValueAdapterKey other) {
            int viewTypeCmp = SetterStore.nullableCompare((Comparable)((Object)this.viewType), (Comparable)((Object)other.viewType));
            if (viewTypeCmp != 0) {
                return viewTypeCmp;
            }
            int attrCmp = SetterStore.stringArrayCompare(this.attributes, other.attributes);
            if (attrCmp != 0) {
                return attrCmp;
            }
            int paramCmp = SetterStore.stringArrayCompare(this.parameterTypes, other.parameterTypes);
            if (paramCmp != 0) {
                return paramCmp;
            }
            int requireAllCmp = Boolean.compare(this.requireAll, other.requireAll);
            if (requireAllCmp != 0) {
                return requireAllCmp;
            }
            int attrIndexCmp = Integer.compare(this.attributeIndices.size(), other.attributeIndices.size());
            if (attrIndexCmp != 0) {
                return attrIndexCmp;
            }
            Iterator<Map.Entry<String, Integer>> myAttrIndices = this.attributeIndices.entrySet().iterator();
            Iterator<Map.Entry<String, Integer>> otherAttrIndices = other.attributeIndices.entrySet().iterator();
            while (myAttrIndices.hasNext() && otherAttrIndices.hasNext()) {
                Map.Entry<String, Integer> myNext = myAttrIndices.next();
                Map.Entry<String, Integer> otherNext = otherAttrIndices.next();
                int keyCmp = SetterStore.nullableCompare((Comparable)((Object)myNext.getKey()), (Comparable)((Object)otherNext.getKey()));
                if (keyCmp != 0) {
                    return keyCmp;
                }
                int valueCmp = SetterStore.nullableCompare(myNext.getValue(), otherNext.getValue());
                if (valueCmp == 0) continue;
                return valueCmp;
            }
            return 0;
        }
    }
}

