/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.ClientOptions;
import java.util.concurrent.TimeUnit;

public class ClusterClientOptions
extends ClientOptions {
    public static final boolean DEFAULT_REFRESH_CLUSTER_VIEW = false;
    public static final long DEFAULT_REFRESH_PERIOD = 60L;
    public static final TimeUnit DEFAULT_REFRESH_PERIOD_UNIT = TimeUnit.SECONDS;
    public static final boolean DEFAULT_CLOSE_STALE_CONNECTIONS = true;
    public static final boolean DEFAULT_VALIDATE_CLUSTER_MEMBERSHIP = true;
    private final boolean refreshClusterView;
    private final long refreshPeriod;
    private final TimeUnit refreshPeriodUnit;
    private final boolean closeStaleConnections;
    private final boolean validateClusterNodeMembership;

    protected ClusterClientOptions(Builder builder) {
        super(builder);
        this.refreshClusterView = builder.refreshClusterView;
        this.refreshPeriod = builder.refreshPeriod;
        this.refreshPeriodUnit = builder.refreshPeriodUnit;
        this.closeStaleConnections = builder.closeStaleConnections;
        this.validateClusterNodeMembership = builder.validateClusterNodeMembership;
    }

    protected ClusterClientOptions(ClusterClientOptions original) {
        super(original);
        this.refreshClusterView = original.refreshClusterView;
        this.refreshPeriod = original.refreshPeriod;
        this.refreshPeriodUnit = original.refreshPeriodUnit;
        this.closeStaleConnections = original.closeStaleConnections;
        this.validateClusterNodeMembership = original.validateClusterNodeMembership;
    }

    public static ClusterClientOptions copyOf(ClusterClientOptions options) {
        return new ClusterClientOptions(options);
    }

    public boolean isRefreshClusterView() {
        return this.refreshClusterView;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public TimeUnit getRefreshPeriodUnit() {
        return this.refreshPeriodUnit;
    }

    public boolean isCloseStaleConnections() {
        return this.closeStaleConnections;
    }

    public boolean isValidateClusterNodeMembership() {
        return this.validateClusterNodeMembership;
    }

    public static ClusterClientOptions create() {
        return new Builder().build();
    }

    public static class Builder
    extends ClientOptions.Builder {
        private boolean refreshClusterView = false;
        private long refreshPeriod = 60L;
        private TimeUnit refreshPeriodUnit = DEFAULT_REFRESH_PERIOD_UNIT;
        private boolean closeStaleConnections = true;
        private boolean validateClusterNodeMembership = true;

        public Builder refreshClusterView(boolean refreshClusterView) {
            this.refreshClusterView = refreshClusterView;
            return this;
        }

        public Builder refreshPeriod(long refreshPeriod, TimeUnit refreshPeriodUnit) {
            this.refreshPeriod = refreshPeriod;
            this.refreshPeriodUnit = refreshPeriodUnit;
            return this;
        }

        public Builder closeStaleConnections(boolean closeStaleConnections) {
            this.closeStaleConnections = closeStaleConnections;
            return this;
        }

        public Builder validateClusterNodeMembership(boolean validateClusterNodeMembership) {
            this.validateClusterNodeMembership = validateClusterNodeMembership;
            return this;
        }

        @Override
        public Builder pingBeforeActivateConnection(boolean pingBeforeActivateConnection) {
            super.pingBeforeActivateConnection(pingBeforeActivateConnection);
            return this;
        }

        @Override
        public Builder autoReconnect(boolean autoReconnect) {
            super.autoReconnect(autoReconnect);
            return this;
        }

        @Override
        public Builder suspendReconnectOnProtocolFailure(boolean suspendReconnectOnProtocolFailure) {
            super.suspendReconnectOnProtocolFailure(suspendReconnectOnProtocolFailure);
            return this;
        }

        @Override
        public Builder cancelCommandsOnReconnectFailure(boolean cancelCommandsOnReconnectFailure) {
            super.cancelCommandsOnReconnectFailure(cancelCommandsOnReconnectFailure);
            return this;
        }

        @Override
        public Builder requestQueueSize(int requestQueueSize) {
            super.requestQueueSize(requestQueueSize);
            return this;
        }

        @Override
        public ClusterClientOptions build() {
            return new ClusterClientOptions(this);
        }
    }
}

