/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class BTS
extends AbstractSegment {
    public BTS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 10, new Object[]{this.getMessage()}, "Batch Message Count");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Batch Comment");
            this.add(NM.class, false, 0, 100, new Object[]{this.getMessage()}, "Batch Totals");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating BTS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getBatchMessageCount() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getBts1_BatchMessageCount() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getBatchComment() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getBts2_BatchComment() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public NM[] getBatchTotals() {
        NM[] retVal = (NM[])this.getTypedField(3, (Type[])new NM[0]);
        return retVal;
    }

    public NM[] getBts3_BatchTotals() {
        NM[] retVal = (NM[])this.getTypedField(3, (Type[])new NM[0]);
        return retVal;
    }

    public int getBatchTotalsReps() {
        return this.getReps(3);
    }

    public NM getBatchTotals(int rep) {
        NM retVal = (NM)this.getTypedField(3, rep);
        return retVal;
    }

    public NM getBts3_BatchTotals(int rep) {
        NM retVal = (NM)this.getTypedField(3, rep);
        return retVal;
    }

    public int getBts3_BatchTotalsReps() {
        return this.getReps(3);
    }

    public NM insertBatchTotals(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(3, rep);
    }

    public NM insertBts3_BatchTotals(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(3, rep);
    }

    public NM removeBatchTotals(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(3, rep);
    }

    public NM removeBts3_BatchTotals(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(3, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

