/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.CWE;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.IS;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.model.v251.datatype.TX;
import ca.uhn.hl7v2.model.v251.datatype.XAD;
import ca.uhn.hl7v2.model.v251.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM1
extends AbstractSegment {
    public OM1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Producer's Service/Test/Observation ID");
            this.add(ID.class, false, 0, 12, new Object[]{this.getMessage(), new Integer(125)}, "Permitted Data Types");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Specimen Required");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Producer ID");
            this.add(TX.class, false, 1, 200, new Object[]{this.getMessage()}, "Observation Description");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Other Service/Test/Observation IDs for the Observation");
            this.add(ST.class, true, 0, 200, new Object[]{this.getMessage()}, "Other Names");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "Preferred Report Name for the Observation");
            this.add(ST.class, false, 1, 8, new Object[]{this.getMessage()}, "Preferred Short Name or Mnemonic for Observation");
            this.add(ST.class, false, 1, 200, new Object[]{this.getMessage()}, "Preferred Long Name for the Observation");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Orderability");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Identity of Instrument Used to Perform this Study");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Coded Representation of Method");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Portable Device Indicator");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Observation Producing Department/Section");
            this.add(XTN.class, false, 1, 250, new Object[]{this.getMessage()}, "Telephone Number of Section");
            this.add(IS.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(174)}, "Nature of Service/Test/Observation");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Report Subheader");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Report Display Order");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time Stamp for any change in Definition for the Observation");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective Date/Time of Change");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Typical Turn-Around Time");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Processing Time");
            this.add(ID.class, false, 0, 40, new Object[]{this.getMessage(), new Integer(168)}, "Processing Priority");
            this.add(ID.class, false, 1, 5, new Object[]{this.getMessage(), new Integer(169)}, "Reporting Priority");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Outside Site(s) Where Observation may be Performed");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Address of Outside Site(s)");
            this.add(XTN.class, false, 1, 250, new Object[]{this.getMessage()}, "Phone Number of Outside Site");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Confidentiality Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Observations Required to Interpret the Observation");
            this.add(TX.class, false, 1, 65536, new Object[]{this.getMessage()}, "Interpretation of Observations");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Contraindications to Observations");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Reflex Tests/Observations");
            this.add(TX.class, false, 1, 80, new Object[]{this.getMessage()}, "Rules that Trigger Reflex Testing");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Fixed Canned Message");
            this.add(TX.class, false, 1, 200, new Object[]{this.getMessage()}, "Patient Preparation");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Procedure Medication");
            this.add(TX.class, false, 1, 200, new Object[]{this.getMessage()}, "Factors that may Affect the Observation");
            this.add(ST.class, false, 0, 60, new Object[]{this.getMessage()}, "Service/Test/Observation Performance Schedule");
            this.add(TX.class, false, 1, 65536, new Object[]{this.getMessage()}, "Description of Test Methods");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Kind of Quantity Observed");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Point Versus Interval");
            this.add(TX.class, false, 1, 200, new Object[]{this.getMessage()}, "Challenge Information");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Relationship Modifier");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Target Anatomic Site Of Test");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Modality Of Imaging Measurement");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OM1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm11_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getProducerSServiceTestObservationID() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getOm12_ProducerSServiceTestObservationID() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public ID[] getPermittedDataTypes() {
        ID[] retVal = (ID[])this.getTypedField(3, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getOm13_PermittedDataTypes() {
        ID[] retVal = (ID[])this.getTypedField(3, (Type[])new ID[0]);
        return retVal;
    }

    public int getPermittedDataTypesReps() {
        return this.getReps(3);
    }

    public ID getPermittedDataTypes(int rep) {
        ID retVal = (ID)this.getTypedField(3, rep);
        return retVal;
    }

    public ID getOm13_PermittedDataTypes(int rep) {
        ID retVal = (ID)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOm13_PermittedDataTypesReps() {
        return this.getReps(3);
    }

    public ID insertPermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID insertOm13_PermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID removePermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ID removeOm13_PermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ID getSpecimenRequired() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getOm14_SpecimenRequired() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getProducerID() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getOm15_ProducerID() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public TX getObservationDescription() {
        TX retVal = (TX)this.getTypedField(6, 0);
        return retVal;
    }

    public TX getOm16_ObservationDescription() {
        TX retVal = (TX)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getOtherServiceTestObservationIDsForTheObservation() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getOm17_OtherServiceTestObservationIDsForTheObservation() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public ST[] getOtherNames() {
        ST[] retVal = (ST[])this.getTypedField(8, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getOm18_OtherNames() {
        ST[] retVal = (ST[])this.getTypedField(8, (Type[])new ST[0]);
        return retVal;
    }

    public int getOtherNamesReps() {
        return this.getReps(8);
    }

    public ST getOtherNames(int rep) {
        ST retVal = (ST)this.getTypedField(8, rep);
        return retVal;
    }

    public ST getOm18_OtherNames(int rep) {
        ST retVal = (ST)this.getTypedField(8, rep);
        return retVal;
    }

    public int getOm18_OtherNamesReps() {
        return this.getReps(8);
    }

    public ST insertOtherNames(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(8, rep);
    }

    public ST insertOm18_OtherNames(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(8, rep);
    }

    public ST removeOtherNames(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(8, rep);
    }

    public ST removeOm18_OtherNames(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(8, rep);
    }

    public ST getPreferredReportNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getOm19_PreferredReportNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getPreferredShortNameOrMnemonicForObservation() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getOm110_PreferredShortNameOrMnemonicForObservation() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getPreferredLongNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getOm111_PreferredLongNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getOrderability() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getOm112_Orderability() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public CE[] getIdentityOfInstrumentUsedToPerformThisStudy() {
        CE[] retVal = (CE[])this.getTypedField(13, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getOm113_IdentityOfInstrumentUsedToPerformThisStudy() {
        CE[] retVal = (CE[])this.getTypedField(13, (Type[])new CE[0]);
        return retVal;
    }

    public int getIdentityOfInstrumentUsedToPerformThisStudyReps() {
        return this.getReps(13);
    }

    public CE getIdentityOfInstrumentUsedToPerformThisStudy(int rep) {
        CE retVal = (CE)this.getTypedField(13, rep);
        return retVal;
    }

    public CE getOm113_IdentityOfInstrumentUsedToPerformThisStudy(int rep) {
        CE retVal = (CE)this.getTypedField(13, rep);
        return retVal;
    }

    public int getOm113_IdentityOfInstrumentUsedToPerformThisStudyReps() {
        return this.getReps(13);
    }

    public CE insertIdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(13, rep);
    }

    public CE insertOm113_IdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(13, rep);
    }

    public CE removeIdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(13, rep);
    }

    public CE removeOm113_IdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(13, rep);
    }

    public CE[] getCodedRepresentationOfMethod() {
        CE[] retVal = (CE[])this.getTypedField(14, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getOm114_CodedRepresentationOfMethod() {
        CE[] retVal = (CE[])this.getTypedField(14, (Type[])new CE[0]);
        return retVal;
    }

    public int getCodedRepresentationOfMethodReps() {
        return this.getReps(14);
    }

    public CE getCodedRepresentationOfMethod(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public CE getOm114_CodedRepresentationOfMethod(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public int getOm114_CodedRepresentationOfMethodReps() {
        return this.getReps(14);
    }

    public CE insertCodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE insertOm114_CodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE removeCodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public CE removeOm114_CodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public ID getPortableDeviceIndicator() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getOm115_PortableDeviceIndicator() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public CE[] getObservationProducingDepartmentSection() {
        CE[] retVal = (CE[])this.getTypedField(16, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getOm116_ObservationProducingDepartmentSection() {
        CE[] retVal = (CE[])this.getTypedField(16, (Type[])new CE[0]);
        return retVal;
    }

    public int getObservationProducingDepartmentSectionReps() {
        return this.getReps(16);
    }

    public CE getObservationProducingDepartmentSection(int rep) {
        CE retVal = (CE)this.getTypedField(16, rep);
        return retVal;
    }

    public CE getOm116_ObservationProducingDepartmentSection(int rep) {
        CE retVal = (CE)this.getTypedField(16, rep);
        return retVal;
    }

    public int getOm116_ObservationProducingDepartmentSectionReps() {
        return this.getReps(16);
    }

    public CE insertObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(16, rep);
    }

    public CE insertOm116_ObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(16, rep);
    }

    public CE removeObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(16, rep);
    }

    public CE removeOm116_ObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(16, rep);
    }

    public XTN getTelephoneNumberOfSection() {
        XTN retVal = (XTN)this.getTypedField(17, 0);
        return retVal;
    }

    public XTN getOm117_TelephoneNumberOfSection() {
        XTN retVal = (XTN)this.getTypedField(17, 0);
        return retVal;
    }

    public IS getNatureOfServiceTestObservation() {
        IS retVal = (IS)this.getTypedField(18, 0);
        return retVal;
    }

    public IS getOm118_NatureOfServiceTestObservation() {
        IS retVal = (IS)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getReportSubheader() {
        CE retVal = (CE)this.getTypedField(19, 0);
        return retVal;
    }

    public CE getOm119_ReportSubheader() {
        CE retVal = (CE)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getReportDisplayOrder() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getOm120_ReportDisplayOrder() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public TS getDateTimeStampForAnyChangeInDefinitionForTheObservation() {
        TS retVal = (TS)this.getTypedField(21, 0);
        return retVal;
    }

    public TS getOm121_DateTimeStampForAnyChangeInDefinitionForTheObservation() {
        TS retVal = (TS)this.getTypedField(21, 0);
        return retVal;
    }

    public TS getEffectiveDateTimeOfChange() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public TS getOm122_EffectiveDateTimeOfChange() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getTypicalTurnAroundTime() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getOm123_TypicalTurnAroundTime() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getProcessingTime() {
        NM retVal = (NM)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getOm124_ProcessingTime() {
        NM retVal = (NM)this.getTypedField(24, 0);
        return retVal;
    }

    public ID[] getProcessingPriority() {
        ID[] retVal = (ID[])this.getTypedField(25, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getOm125_ProcessingPriority() {
        ID[] retVal = (ID[])this.getTypedField(25, (Type[])new ID[0]);
        return retVal;
    }

    public int getProcessingPriorityReps() {
        return this.getReps(25);
    }

    public ID getProcessingPriority(int rep) {
        ID retVal = (ID)this.getTypedField(25, rep);
        return retVal;
    }

    public ID getOm125_ProcessingPriority(int rep) {
        ID retVal = (ID)this.getTypedField(25, rep);
        return retVal;
    }

    public int getOm125_ProcessingPriorityReps() {
        return this.getReps(25);
    }

    public ID insertProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(25, rep);
    }

    public ID insertOm125_ProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(25, rep);
    }

    public ID removeProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(25, rep);
    }

    public ID removeOm125_ProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(25, rep);
    }

    public ID getReportingPriority() {
        ID retVal = (ID)this.getTypedField(26, 0);
        return retVal;
    }

    public ID getOm126_ReportingPriority() {
        ID retVal = (ID)this.getTypedField(26, 0);
        return retVal;
    }

    public CE[] getOutsideSiteSWhereObservationMayBePerformed() {
        CE[] retVal = (CE[])this.getTypedField(27, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getOm127_OutsideSiteSWhereObservationMayBePerformed() {
        CE[] retVal = (CE[])this.getTypedField(27, (Type[])new CE[0]);
        return retVal;
    }

    public int getOutsideSiteSWhereObservationMayBePerformedReps() {
        return this.getReps(27);
    }

    public CE getOutsideSiteSWhereObservationMayBePerformed(int rep) {
        CE retVal = (CE)this.getTypedField(27, rep);
        return retVal;
    }

    public CE getOm127_OutsideSiteSWhereObservationMayBePerformed(int rep) {
        CE retVal = (CE)this.getTypedField(27, rep);
        return retVal;
    }

    public int getOm127_OutsideSiteSWhereObservationMayBePerformedReps() {
        return this.getReps(27);
    }

    public CE insertOutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(27, rep);
    }

    public CE insertOm127_OutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(27, rep);
    }

    public CE removeOutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(27, rep);
    }

    public CE removeOm127_OutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(27, rep);
    }

    public XAD[] getAddressOfOutsideSiteS() {
        XAD[] retVal = (XAD[])this.getTypedField(28, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getOm128_AddressOfOutsideSiteS() {
        XAD[] retVal = (XAD[])this.getTypedField(28, (Type[])new XAD[0]);
        return retVal;
    }

    public int getAddressOfOutsideSiteSReps() {
        return this.getReps(28);
    }

    public XAD getAddressOfOutsideSiteS(int rep) {
        XAD retVal = (XAD)this.getTypedField(28, rep);
        return retVal;
    }

    public XAD getOm128_AddressOfOutsideSiteS(int rep) {
        XAD retVal = (XAD)this.getTypedField(28, rep);
        return retVal;
    }

    public int getOm128_AddressOfOutsideSiteSReps() {
        return this.getReps(28);
    }

    public XAD insertAddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(28, rep);
    }

    public XAD insertOm128_AddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(28, rep);
    }

    public XAD removeAddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(28, rep);
    }

    public XAD removeOm128_AddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(28, rep);
    }

    public XTN getPhoneNumberOfOutsideSite() {
        XTN retVal = (XTN)this.getTypedField(29, 0);
        return retVal;
    }

    public XTN getOm129_PhoneNumberOfOutsideSite() {
        XTN retVal = (XTN)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getConfidentialityCode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getOm130_ConfidentialityCode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CE getObservationsRequiredToInterpretTheObservation() {
        CE retVal = (CE)this.getTypedField(31, 0);
        return retVal;
    }

    public CE getOm131_ObservationsRequiredToInterpretTheObservation() {
        CE retVal = (CE)this.getTypedField(31, 0);
        return retVal;
    }

    public TX getInterpretationOfObservations() {
        TX retVal = (TX)this.getTypedField(32, 0);
        return retVal;
    }

    public TX getOm132_InterpretationOfObservations() {
        TX retVal = (TX)this.getTypedField(32, 0);
        return retVal;
    }

    public CE getContraindicationsToObservations() {
        CE retVal = (CE)this.getTypedField(33, 0);
        return retVal;
    }

    public CE getOm133_ContraindicationsToObservations() {
        CE retVal = (CE)this.getTypedField(33, 0);
        return retVal;
    }

    public CE[] getReflexTestsObservations() {
        CE[] retVal = (CE[])this.getTypedField(34, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getOm134_ReflexTestsObservations() {
        CE[] retVal = (CE[])this.getTypedField(34, (Type[])new CE[0]);
        return retVal;
    }

    public int getReflexTestsObservationsReps() {
        return this.getReps(34);
    }

    public CE getReflexTestsObservations(int rep) {
        CE retVal = (CE)this.getTypedField(34, rep);
        return retVal;
    }

    public CE getOm134_ReflexTestsObservations(int rep) {
        CE retVal = (CE)this.getTypedField(34, rep);
        return retVal;
    }

    public int getOm134_ReflexTestsObservationsReps() {
        return this.getReps(34);
    }

    public CE insertReflexTestsObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(34, rep);
    }

    public CE insertOm134_ReflexTestsObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(34, rep);
    }

    public CE removeReflexTestsObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(34, rep);
    }

    public CE removeOm134_ReflexTestsObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(34, rep);
    }

    public TX getRulesThatTriggerReflexTesting() {
        TX retVal = (TX)this.getTypedField(35, 0);
        return retVal;
    }

    public TX getOm135_RulesThatTriggerReflexTesting() {
        TX retVal = (TX)this.getTypedField(35, 0);
        return retVal;
    }

    public CE getFixedCannedMessage() {
        CE retVal = (CE)this.getTypedField(36, 0);
        return retVal;
    }

    public CE getOm136_FixedCannedMessage() {
        CE retVal = (CE)this.getTypedField(36, 0);
        return retVal;
    }

    public TX getPatientPreparation() {
        TX retVal = (TX)this.getTypedField(37, 0);
        return retVal;
    }

    public TX getOm137_PatientPreparation() {
        TX retVal = (TX)this.getTypedField(37, 0);
        return retVal;
    }

    public CE getProcedureMedication() {
        CE retVal = (CE)this.getTypedField(38, 0);
        return retVal;
    }

    public CE getOm138_ProcedureMedication() {
        CE retVal = (CE)this.getTypedField(38, 0);
        return retVal;
    }

    public TX getFactorsThatMayAffectTheObservation() {
        TX retVal = (TX)this.getTypedField(39, 0);
        return retVal;
    }

    public TX getOm139_FactorsThatMayAffectTheObservation() {
        TX retVal = (TX)this.getTypedField(39, 0);
        return retVal;
    }

    public ST[] getServiceTestObservationPerformanceSchedule() {
        ST[] retVal = (ST[])this.getTypedField(40, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getOm140_ServiceTestObservationPerformanceSchedule() {
        ST[] retVal = (ST[])this.getTypedField(40, (Type[])new ST[0]);
        return retVal;
    }

    public int getServiceTestObservationPerformanceScheduleReps() {
        return this.getReps(40);
    }

    public ST getServiceTestObservationPerformanceSchedule(int rep) {
        ST retVal = (ST)this.getTypedField(40, rep);
        return retVal;
    }

    public ST getOm140_ServiceTestObservationPerformanceSchedule(int rep) {
        ST retVal = (ST)this.getTypedField(40, rep);
        return retVal;
    }

    public int getOm140_ServiceTestObservationPerformanceScheduleReps() {
        return this.getReps(40);
    }

    public ST insertServiceTestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(40, rep);
    }

    public ST insertOm140_ServiceTestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(40, rep);
    }

    public ST removeServiceTestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(40, rep);
    }

    public ST removeOm140_ServiceTestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(40, rep);
    }

    public TX getDescriptionOfTestMethods() {
        TX retVal = (TX)this.getTypedField(41, 0);
        return retVal;
    }

    public TX getOm141_DescriptionOfTestMethods() {
        TX retVal = (TX)this.getTypedField(41, 0);
        return retVal;
    }

    public CE getKindOfQuantityObserved() {
        CE retVal = (CE)this.getTypedField(42, 0);
        return retVal;
    }

    public CE getOm142_KindOfQuantityObserved() {
        CE retVal = (CE)this.getTypedField(42, 0);
        return retVal;
    }

    public CE getPointVersusInterval() {
        CE retVal = (CE)this.getTypedField(43, 0);
        return retVal;
    }

    public CE getOm143_PointVersusInterval() {
        CE retVal = (CE)this.getTypedField(43, 0);
        return retVal;
    }

    public TX getChallengeInformation() {
        TX retVal = (TX)this.getTypedField(44, 0);
        return retVal;
    }

    public TX getOm144_ChallengeInformation() {
        TX retVal = (TX)this.getTypedField(44, 0);
        return retVal;
    }

    public CE getRelationshipModifier() {
        CE retVal = (CE)this.getTypedField(45, 0);
        return retVal;
    }

    public CE getOm145_RelationshipModifier() {
        CE retVal = (CE)this.getTypedField(45, 0);
        return retVal;
    }

    public CE getTargetAnatomicSiteOfTest() {
        CE retVal = (CE)this.getTypedField(46, 0);
        return retVal;
    }

    public CE getOm146_TargetAnatomicSiteOfTest() {
        CE retVal = (CE)this.getTypedField(46, 0);
        return retVal;
    }

    public CE getModalityOfImagingMeasurement() {
        CE retVal = (CE)this.getTypedField(47, 0);
        return retVal;
    }

    public CE getOm147_ModalityOfImagingMeasurement() {
        CE retVal = (CE)this.getTypedField(47, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(125));
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new TX(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new ST(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new XTN(this.getMessage());
            }
            case 17: {
                return new IS(this.getMessage(), new Integer(174));
            }
            case 18: {
                return new CE(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new TS(this.getMessage());
            }
            case 21: {
                return new TS(this.getMessage());
            }
            case 22: {
                return new NM(this.getMessage());
            }
            case 23: {
                return new NM(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(168));
            }
            case 25: {
                return new ID(this.getMessage(), new Integer(169));
            }
            case 26: {
                return new CE(this.getMessage());
            }
            case 27: {
                return new XAD(this.getMessage());
            }
            case 28: {
                return new XTN(this.getMessage());
            }
            case 29: {
                return new CWE(this.getMessage());
            }
            case 30: {
                return new CE(this.getMessage());
            }
            case 31: {
                return new TX(this.getMessage());
            }
            case 32: {
                return new CE(this.getMessage());
            }
            case 33: {
                return new CE(this.getMessage());
            }
            case 34: {
                return new TX(this.getMessage());
            }
            case 35: {
                return new CE(this.getMessage());
            }
            case 36: {
                return new TX(this.getMessage());
            }
            case 37: {
                return new CE(this.getMessage());
            }
            case 38: {
                return new TX(this.getMessage());
            }
            case 39: {
                return new ST(this.getMessage());
            }
            case 40: {
                return new TX(this.getMessage());
            }
            case 41: {
                return new CE(this.getMessage());
            }
            case 42: {
                return new CE(this.getMessage());
            }
            case 43: {
                return new TX(this.getMessage());
            }
            case 44: {
                return new CE(this.getMessage());
            }
            case 45: {
                return new CE(this.getMessage());
            }
            case 46: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

