/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import org.acra.annotation.AcraDialog;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.ClassValidator;
import org.acra.config.ConfigurationBuilder;
import org.acra.config.DialogConfiguration;
import org.acra.dialog.BaseCrashReportDialog;
import org.acra.dialog.CrashReportDialog;

public final class DialogConfigurationBuilder
implements ConfigurationBuilder {
    private Boolean enabled;
    private Class<? extends BaseCrashReportDialog> reportDialogClass;
    @StringRes
    private Integer resPositiveButtonText;
    @StringRes
    private Integer resNegativeButtonText;
    @StringRes
    private Integer resCommentPrompt;
    @StringRes
    private Integer resEmailPrompt;
    @DrawableRes
    private Integer resIcon;
    @StringRes
    private Integer resText;
    @StringRes
    private Integer resTitle;
    @StyleRes
    private Integer resTheme;

    public DialogConfigurationBuilder(@NonNull Object arg0) {
        this(arg0.getClass());
    }

    public DialogConfigurationBuilder(@NonNull Class<?> arg0) {
        AcraDialog var0 = arg0.getAnnotation(AcraDialog.class);
        this.enabled = var0 != null;
        if (this.enabled.booleanValue()) {
            this.reportDialogClass = var0.reportDialogClass();
            this.resPositiveButtonText = var0.resPositiveButtonText();
            this.resNegativeButtonText = var0.resNegativeButtonText();
            this.resCommentPrompt = var0.resCommentPrompt();
            this.resEmailPrompt = var0.resEmailPrompt();
            this.resIcon = var0.resIcon();
            this.resText = var0.resText();
            this.resTitle = var0.resTitle();
            this.resTheme = var0.resTheme();
        }
    }

    boolean enabled() {
        return this.enabled;
    }

    @NonNull
    public DialogConfigurationBuilder setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    Class<? extends BaseCrashReportDialog> reportDialogClass() {
        return this.reportDialogClass != null ? this.reportDialogClass : CrashReportDialog.class;
    }

    @NonNull
    public DialogConfigurationBuilder setReportDialogClass(Class<? extends BaseCrashReportDialog> reportDialogClass) {
        this.reportDialogClass = reportDialogClass;
        return this;
    }

    @StringRes
    int resPositiveButtonText() {
        return this.resPositiveButtonText != null ? this.resPositiveButtonText : 17039370;
    }

    @NonNull
    public DialogConfigurationBuilder setResPositiveButtonText(@StringRes int resPositiveButtonText) {
        this.resPositiveButtonText = resPositiveButtonText;
        return this;
    }

    @StringRes
    int resNegativeButtonText() {
        return this.resNegativeButtonText != null ? this.resNegativeButtonText : 0x1040000;
    }

    @NonNull
    public DialogConfigurationBuilder setResNegativeButtonText(@StringRes int resNegativeButtonText) {
        this.resNegativeButtonText = resNegativeButtonText;
        return this;
    }

    @StringRes
    int resCommentPrompt() {
        return this.resCommentPrompt != null ? this.resCommentPrompt : 0;
    }

    @NonNull
    public DialogConfigurationBuilder setResCommentPrompt(@StringRes int resCommentPrompt) {
        this.resCommentPrompt = resCommentPrompt;
        return this;
    }

    @StringRes
    int resEmailPrompt() {
        return this.resEmailPrompt != null ? this.resEmailPrompt : 0;
    }

    @NonNull
    public DialogConfigurationBuilder setResEmailPrompt(@StringRes int resEmailPrompt) {
        this.resEmailPrompt = resEmailPrompt;
        return this;
    }

    @DrawableRes
    int resIcon() {
        return this.resIcon != null ? this.resIcon : 17301543;
    }

    @NonNull
    public DialogConfigurationBuilder setResIcon(@DrawableRes int resIcon) {
        this.resIcon = resIcon;
        return this;
    }

    @StringRes
    int resText() {
        return this.resText != null ? this.resText : 0;
    }

    @NonNull
    public DialogConfigurationBuilder setResText(@StringRes int resText) {
        this.resText = resText;
        return this;
    }

    @StringRes
    int resTitle() {
        return this.resTitle != null ? this.resTitle : 0;
    }

    @NonNull
    public DialogConfigurationBuilder setResTitle(@StringRes int resTitle) {
        this.resTitle = resTitle;
        return this;
    }

    @StyleRes
    int resTheme() {
        return this.resTheme != null ? this.resTheme : 0;
    }

    @NonNull
    public DialogConfigurationBuilder setResTheme(@StyleRes int resTheme) {
        this.resTheme = resTheme;
        return this;
    }

    @NonNull
    public DialogConfiguration build() throws ACRAConfigurationException {
        if (this.enabled.booleanValue()) {
            ClassValidator.check((Class[])new Class[]{this.reportDialogClass()});
            if (this.reportDialogClass() == CrashReportDialog.class && this.resText() == 0) {
                throw new ACRAConfigurationException("One of reportDialogClass, resText must not be default");
            }
        }
        return new DialogConfiguration(this);
    }
}

