/*
 * Decompiled with CFR 0.152.
 */
package org.acra.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.DialogConfiguration;
import org.acra.dialog.BaseCrashReportDialog;
import org.acra.prefs.SharedPreferencesFactory;

public class CrashReportDialog
extends BaseCrashReportDialog
implements DialogInterface.OnClickListener {
    private static final String STATE_EMAIL = "email";
    private static final String STATE_COMMENT = "comment";
    private static final int PADDING = 10;
    private LinearLayout scrollable;
    private EditText userCommentView;
    private EditText userEmailView;
    private SharedPreferencesFactory sharedPreferencesFactory;
    private DialogConfiguration dialogConfiguration;
    private AlertDialog mDialog;

    @Override
    @CallSuper
    protected void init(@Nullable Bundle savedInstanceState) {
        this.scrollable = new LinearLayout((Context)this);
        this.scrollable.setOrientation(1);
        this.sharedPreferencesFactory = new SharedPreferencesFactory(this.getApplicationContext(), this.getConfig());
        this.dialogConfiguration = (DialogConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)this.getConfig(), DialogConfiguration.class);
        int themeResourceId = this.dialogConfiguration.resTheme();
        if (themeResourceId != 0) {
            this.setTheme(themeResourceId);
        }
        this.buildAndShowDialog(savedInstanceState);
    }

    protected void buildAndShowDialog(@Nullable Bundle savedInstanceState) {
        int iconResourceId;
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)this);
        int titleResourceId = this.dialogConfiguration.resTitle();
        if (titleResourceId != 0) {
            dialogBuilder.setTitle(titleResourceId);
        }
        if ((iconResourceId = this.dialogConfiguration.resIcon()) != 0) {
            dialogBuilder.setIcon(iconResourceId);
        }
        dialogBuilder.setView(this.buildCustomView(savedInstanceState)).setPositiveButton(this.getText(this.dialogConfiguration.resPositiveButtonText()), (DialogInterface.OnClickListener)this).setNegativeButton(this.getText(this.dialogConfiguration.resNegativeButtonText()), (DialogInterface.OnClickListener)this);
        this.mDialog = dialogBuilder.create();
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.show();
    }

    @NonNull
    protected View buildCustomView(@Nullable Bundle savedInstanceState) {
        View email;
        ScrollView root = new ScrollView((Context)this);
        root.setPadding(10, 10, 10, 10);
        root.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        root.setFocusable(true);
        root.setFocusableInTouchMode(true);
        root.addView((View)this.scrollable);
        this.addViewToDialog(this.getMainView());
        View comment = this.getCommentLabel();
        if (comment != null) {
            comment.setPadding(comment.getPaddingLeft(), 10, comment.getPaddingRight(), comment.getPaddingBottom());
            this.addViewToDialog(comment);
            String savedComment = null;
            if (savedInstanceState != null) {
                savedComment = savedInstanceState.getString(STATE_COMMENT);
            }
            this.userCommentView = this.getCommentPrompt(savedComment);
            this.addViewToDialog((View)this.userCommentView);
        }
        if ((email = this.getEmailLabel()) != null) {
            email.setPadding(email.getPaddingLeft(), 10, email.getPaddingRight(), email.getPaddingBottom());
            this.addViewToDialog(email);
            String savedEmail = null;
            if (savedInstanceState != null) {
                savedEmail = savedInstanceState.getString(STATE_EMAIL);
            }
            this.userEmailView = this.getEmailPrompt(savedEmail);
            this.addViewToDialog((View)this.userEmailView);
        }
        return root;
    }

    protected final void addViewToDialog(@NonNull View v) {
        this.scrollable.addView(v);
    }

    @NonNull
    protected View getMainView() {
        TextView text = new TextView((Context)this);
        int dialogTextId = this.dialogConfiguration.resText();
        if (dialogTextId != 0) {
            text.setText(this.getText(dialogTextId));
        }
        return text;
    }

    @Nullable
    protected View getCommentLabel() {
        int commentPromptId = this.dialogConfiguration.resCommentPrompt();
        if (commentPromptId != 0) {
            TextView labelView = new TextView((Context)this);
            labelView.setText(this.getText(commentPromptId));
            return labelView;
        }
        return null;
    }

    @NonNull
    protected EditText getCommentPrompt(@Nullable CharSequence savedComment) {
        EditText userCommentView = new EditText((Context)this);
        userCommentView.setLines(2);
        if (savedComment != null) {
            userCommentView.setText(savedComment);
        }
        return userCommentView;
    }

    @Nullable
    protected View getEmailLabel() {
        int emailPromptId = this.dialogConfiguration.resEmailPrompt();
        if (emailPromptId != 0) {
            TextView labelView = new TextView((Context)this);
            labelView.setText(this.getText(emailPromptId));
            return labelView;
        }
        return null;
    }

    @NonNull
    protected EditText getEmailPrompt(@Nullable CharSequence savedEmail) {
        EditText userEmailView = new EditText((Context)this);
        userEmailView.setSingleLine();
        userEmailView.setInputType(33);
        if (savedEmail != null) {
            userEmailView.setText(savedEmail);
        } else {
            SharedPreferences prefs = this.sharedPreferencesFactory.create();
            userEmailView.setText((CharSequence)prefs.getString("acra.user.email", ""));
        }
        return userEmailView;
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            String userEmail;
            String comment = this.userCommentView != null ? this.userCommentView.getText().toString() : "";
            SharedPreferences prefs = this.sharedPreferencesFactory.create();
            if (this.userEmailView != null) {
                userEmail = this.userEmailView.getText().toString();
                prefs.edit().putString("acra.user.email", userEmail).apply();
            } else {
                userEmail = prefs.getString("acra.user.email", "");
            }
            this.sendCrash(comment, userEmail);
        } else {
            this.cancelReports();
        }
        this.finish();
    }

    @CallSuper
    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.userCommentView != null && this.userCommentView.getText() != null) {
            outState.putString(STATE_COMMENT, this.userCommentView.getText().toString());
        }
        if (this.userEmailView != null && this.userEmailView.getText() != null) {
            outState.putString(STATE_EMAIL, this.userEmailView.getText().toString());
        }
    }

    protected AlertDialog getDialog() {
        return this.mDialog;
    }
}

