/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator;

import cloud.tianai.captcha.common.exception.ImageCaptchaException;
import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.generator.ImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.CaptchaExchange;
import cloud.tianai.captcha.generator.common.model.dto.CustomData;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.generator.impl.transform.Base64ImageTransform;
import cloud.tianai.captcha.interceptor.CaptchaInterceptor;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImageCaptchaGenerator
implements ImageCaptchaGenerator {
    private static final Logger log = LoggerFactory.getLogger(AbstractImageCaptchaGenerator.class);
    public static String DEFAULT_BG_IMAGE_TYPE = "jpeg";
    public static String DEFAULT_SLIDER_IMAGE_TYPE = "png";
    public String defaultBgImageType = DEFAULT_BG_IMAGE_TYPE;
    public String defaultSliderImageType = DEFAULT_SLIDER_IMAGE_TYPE;
    protected ImageCaptchaResourceManager imageCaptchaResourceManager;
    protected ImageTransform imageTransform;
    protected CaptchaInterceptor interceptor;
    private boolean init = false;

    public AbstractImageCaptchaGenerator() {
    }

    @Override
    public ImageCaptchaGenerator init() {
        if (this.init) {
            return this;
        }
        this.init = true;
        try {
            log.info("\u56fe\u7247\u9a8c\u8bc1\u7801[{}]\u521d\u59cb\u5316...", (Object)this.getClass().getSimpleName());
            if (this.getImageTransform() == null) {
                this.setImageTransform(new Base64ImageTransform());
            }
            this.doInit();
        }
        catch (Exception e) {
            this.init = false;
            log.error("[{}]\u521d\u59cb\u5316\u5931\u8d25,ex", (Object)this.getClass().getSimpleName(), (Object)e);
            throw e;
        }
        return this;
    }

    public AbstractImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        this.imageCaptchaResourceManager = imageCaptchaResourceManager;
    }

    @Override
    public ImageCaptchaInfo generateCaptchaImage(String type) {
        return this.generateCaptchaImage(type, this.defaultBgImageType, this.defaultSliderImageType);
    }

    @Override
    public ImageCaptchaInfo generateCaptchaImage(String type, String backgroundFormatName, String templateFormatName) {
        return this.generateCaptchaImage(GenerateParam.builder().type(type).backgroundFormatName(backgroundFormatName).templateFormatName(templateFormatName).obfuscate(false).build());
    }

    @Override
    public ImageCaptchaInfo generateCaptchaImage(GenerateParam param) {
        this.assertInit();
        CustomData data = new CustomData();
        CaptchaExchange captchaExchange = CaptchaExchange.create(data, param);
        ImageCaptchaInfo imageCaptchaInfo = this.beforeGenerate(captchaExchange);
        if (imageCaptchaInfo != null) {
            return imageCaptchaInfo;
        }
        this.doGenerateCaptchaImage(captchaExchange);
        this.beforeWrapImageCaptchaInfo(captchaExchange);
        imageCaptchaInfo = this.wrapImageCaptchaInfo(captchaExchange);
        this.afterGenerateCaptchaImage(captchaExchange, imageCaptchaInfo);
        return imageCaptchaInfo;
    }

    protected void afterGenerateCaptchaImage(CaptchaExchange captchaExchange, ImageCaptchaInfo imageCaptchaInfo) {
        if (this.interceptor != null) {
            this.interceptor.afterGenerateCaptchaImage(this.interceptor.createContext(), captchaExchange, imageCaptchaInfo, this);
        }
    }

    protected void beforeWrapImageCaptchaInfo(CaptchaExchange captchaExchange) {
        if (this.interceptor != null) {
            this.interceptor.beforeWrapImageCaptchaInfo(this.interceptor.createContext(), captchaExchange, this);
        }
    }

    protected ImageCaptchaInfo beforeGenerate(CaptchaExchange captchaExchange) {
        if (this.interceptor != null) {
            return this.interceptor.beforeGenerateCaptchaImage(this.interceptor.createContext(), captchaExchange, this);
        }
        return null;
    }

    public ImageCaptchaInfo wrapImageCaptchaInfo(CaptchaExchange captchaExchange) {
        ImageCaptchaInfo imageCaptchaInfo = this.doWrapImageCaptchaInfo(captchaExchange);
        imageCaptchaInfo.setData(captchaExchange.getCustomData());
        return imageCaptchaInfo;
    }

    protected ResourceMap requiredRandomGetTemplate(String type, String tag) {
        ResourceMap templateMap = this.imageCaptchaResourceManager.randomGetTemplate(type, tag);
        if (templateMap == null || CollectionUtils.isEmpty(templateMap.getResourceMap())) {
            throw new ImageCaptchaException("\u968f\u673a\u83b7\u53d6\u6a21\u677f\u8d44\u6e90\u5931\u8d25\uff0c \u83b7\u53d6\u5230\u7684\u8d44\u6e90\u4e3a\u7a7a, type=" + type + ",tag=" + tag);
        }
        return templateMap;
    }

    protected Resource requiredRandomGetResource(String type, String tag) {
        Resource resource = this.imageCaptchaResourceManager.randomGetResource(type, tag);
        if (resource == null) {
            throw new ImageCaptchaException("\u968f\u673a\u83b7\u53d6\u8d44\u6e90\u5931\u8d25\uff0c \u83b7\u53d6\u5230\u7684\u8d44\u6e90\u4e3a\u7a7a, type=" + type + ",tag=" + tag);
        }
        return resource;
    }

    protected InputStream getTemplateFile(ResourceMap templateImages, String imageName) {
        Resource resource = templateImages.get(imageName);
        if (resource == null) {
            throw new IllegalArgumentException("\u67e5\u627e\u6a21\u677f\u5f02\u5e38\uff0c \u8be5\u6a21\u677f\u4e0b\u672a\u627e\u5230 ".concat(imageName));
        }
        return this.getResourceInputStream(resource, null);
    }

    protected BufferedImage getTemplateImage(ResourceMap templateImages, String imageName) {
        InputStream stream = this.getTemplateFile(templateImages, imageName);
        BufferedImage bufferedImage = CaptchaImageUtils.wrapFile2BufferedImage(stream);
        this.closeStream(stream);
        return bufferedImage;
    }

    protected BufferedImage getResourceImage(Resource resource) {
        InputStream stream = this.getResourceInputStream(resource, null);
        BufferedImage bufferedImage = CaptchaImageUtils.wrapFile2BufferedImage(stream);
        this.closeStream(stream);
        return bufferedImage;
    }

    protected int randomInt(int origin, int bound) {
        return ThreadLocalRandom.current().nextInt(origin, bound);
    }

    protected boolean randomBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    protected int randomInt(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }

    public void closeStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected InputStream getResourceInputStream(Resource resource, Collection<InputStream> inputStreams) {
        InputStream stream = this.getImageResourceManager().getResourceInputStream(resource);
        if (stream != null && inputStreams != null) {
            inputStreams.add(stream);
        }
        return stream;
    }

    protected Optional<BufferedImage> getTemplateImageOfOptional(ResourceMap templateImages, String imageName) {
        Optional<InputStream> optional = this.getTemplateFileOfOptional(templateImages, imageName);
        if (optional.isPresent()) {
            InputStream inputStream = optional.get();
            BufferedImage bufferedImage = CaptchaImageUtils.wrapFile2BufferedImage(inputStream);
            this.closeStream(inputStream);
            return Optional.ofNullable(bufferedImage);
        }
        return Optional.empty();
    }

    protected Optional<InputStream> getTemplateFileOfOptional(ResourceMap templateImages, String imageName) {
        Resource resource = templateImages.get(imageName);
        if (resource == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getResourceInputStream(resource, null));
    }

    protected void assertInit() {
        if (!this.init) {
            throw new IllegalStateException("\u8bf7\u5148\u8c03\u7528 init(...) \u521d\u59cb\u5316\u65b9\u6cd5\u8fdb\u884c\u521d\u59cb\u5316");
        }
    }

    protected abstract void doInit();

    protected abstract void doGenerateCaptchaImage(CaptchaExchange var1);

    protected abstract ImageCaptchaInfo doWrapImageCaptchaInfo(CaptchaExchange var1);

    @Override
    public ImageCaptchaResourceManager getImageResourceManager() {
        return this.imageCaptchaResourceManager;
    }

    @Override
    public void setImageResourceManager(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        this.imageCaptchaResourceManager = imageCaptchaResourceManager;
    }

    @Override
    public ImageTransform getImageTransform() {
        return this.imageTransform;
    }

    @Override
    public void setImageTransform(ImageTransform imageTransform) {
        this.imageTransform = imageTransform;
    }

    @Override
    public CaptchaInterceptor getInterceptor() {
        return this.interceptor;
    }

    @Override
    public void setInterceptor(CaptchaInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public String getDefaultBgImageType() {
        return this.defaultBgImageType;
    }

    public void setDefaultBgImageType(String defaultBgImageType) {
        this.defaultBgImageType = defaultBgImageType;
    }

    public String getDefaultSliderImageType() {
        return this.defaultSliderImageType;
    }

    public void setDefaultSliderImageType(String defaultSliderImageType) {
        this.defaultSliderImageType = defaultSliderImageType;
    }

    public boolean isInit() {
        return this.init;
    }
}

