/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.common.util.ObjectUtils;
import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageCaptchaGeneratorProvider;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.FontWrapper;
import cloud.tianai.captcha.generator.common.model.dto.CaptchaExchange;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.impl.StandardConcatImageCaptchaGenerator;
import cloud.tianai.captcha.generator.impl.StandardRotateImageCaptchaGenerator;
import cloud.tianai.captcha.generator.impl.StandardSliderImageCaptchaGenerator;
import cloud.tianai.captcha.generator.impl.StandardWordClickImageCaptchaGenerator;
import cloud.tianai.captcha.generator.impl.provider.CommonImageCaptchaGeneratorProvider;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MultiImageCaptchaGenerator
extends AbstractImageCaptchaGenerator {
    protected Map<String, ImageCaptchaGenerator> imageCaptchaGeneratorMap = new ConcurrentHashMap<String, ImageCaptchaGenerator>(4);
    protected Map<String, ImageCaptchaGeneratorProvider> imageCaptchaGeneratorProviderMap = new HashMap<String, ImageCaptchaGeneratorProvider>(4);
    protected List<FontWrapper> fontWrappers;
    private String defaultCaptcha = "SLIDER";

    public MultiImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public MultiImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
    }

    @Override
    protected void doInit() {
        this.addImageCaptchaGeneratorProvider(new CommonImageCaptchaGeneratorProvider("SLIDER", StandardSliderImageCaptchaGenerator::new));
        this.addImageCaptchaGeneratorProvider(new CommonImageCaptchaGeneratorProvider("ROTATE", StandardRotateImageCaptchaGenerator::new));
        this.addImageCaptchaGeneratorProvider(new CommonImageCaptchaGeneratorProvider("CONCAT", StandardConcatImageCaptchaGenerator::new));
        this.addImageCaptchaGeneratorProvider(new CommonImageCaptchaGeneratorProvider("WORD_IMAGE_CLICK", (r, t, i) -> new StandardWordClickImageCaptchaGenerator(r, t, i, this.fontWrappers)));
    }

    public void addImageCaptchaGeneratorProvider(ImageCaptchaGeneratorProvider provider) {
        this.imageCaptchaGeneratorProviderMap.put(provider.getType(), provider);
    }

    public ImageCaptchaGeneratorProvider removeImageCaptchaGeneratorProvider(String type) {
        return this.imageCaptchaGeneratorProviderMap.remove(type);
    }

    public ImageCaptchaGeneratorProvider getImageCaptchaGeneratorProvider(String type) {
        return this.imageCaptchaGeneratorProviderMap.get(type);
    }

    public void addImageCaptchaGenerator(String key, ImageCaptchaGenerator captchaGenerator) {
        this.imageCaptchaGeneratorMap.put(key, captchaGenerator);
    }

    public ImageCaptchaGenerator removeImageCaptchaGenerator(String key) {
        return this.imageCaptchaGeneratorMap.remove(key);
    }

    public ImageCaptchaGenerator getImageCaptchaGenerator(String key) {
        return this.imageCaptchaGeneratorMap.get(key);
    }

    @Override
    public ImageCaptchaInfo generateCaptchaImage(GenerateParam param) {
        String type = param.getType();
        if (ObjectUtils.isEmpty(type)) {
            param.setType(this.defaultCaptcha);
            type = this.defaultCaptcha;
        }
        ImageCaptchaGenerator imageCaptchaGenerator = this.requireGetCaptchaGenerator(type);
        return imageCaptchaGenerator.generateCaptchaImage(param);
    }

    @Override
    protected void doGenerateCaptchaImage(CaptchaExchange captchaExchange) {
    }

    @Override
    protected ImageCaptchaInfo doWrapImageCaptchaInfo(CaptchaExchange captchaExchange) {
        return null;
    }

    public ImageCaptchaGenerator requireGetCaptchaGenerator(String type) {
        ImageCaptchaGenerator imageCaptchaGenerator = this.imageCaptchaGeneratorMap.computeIfAbsent(type, t -> {
            ImageCaptchaGeneratorProvider provider = this.imageCaptchaGeneratorProviderMap.get(t);
            if (provider == null) {
                throw new IllegalArgumentException("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u9519\u8bef\u7684type\u7c7b\u578b:" + t);
            }
            return provider.get(this.getImageResourceManager(), this.getImageTransform(), this.getInterceptor()).init();
        });
        return imageCaptchaGenerator;
    }

    @Override
    public void setImageResourceManager(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super.setImageResourceManager(imageCaptchaResourceManager);
        for (ImageCaptchaGenerator imageCaptchaGenerator : this.imageCaptchaGeneratorMap.values()) {
            imageCaptchaGenerator.setImageResourceManager(imageCaptchaResourceManager);
        }
    }

    @Override
    public void setImageTransform(ImageTransform imageTransform) {
        super.setImageTransform(imageTransform);
        for (ImageCaptchaGenerator imageCaptchaGenerator : this.imageCaptchaGeneratorMap.values()) {
            imageCaptchaGenerator.setImageTransform(imageTransform);
        }
    }

    public void setFontWrappers(List<FontWrapper> fontWrappers) {
        this.fontWrappers = fontWrappers;
    }

    public List<FontWrapper> getFontWrappers() {
        return this.fontWrappers;
    }

    public void setDefaultCaptcha(String defaultCaptcha) {
        this.defaultCaptcha = defaultCaptcha;
    }

    public String getDefaultCaptcha() {
        return this.defaultCaptcha;
    }
}

