/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.common.exception.ImageCaptchaException;
import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.common.util.FontUtils;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.FontWrapper;
import cloud.tianai.captcha.generator.common.model.dto.CaptchaExchange;
import cloud.tianai.captcha.generator.common.model.dto.ClickImageCheckDefinition;
import cloud.tianai.captcha.generator.common.model.dto.CustomData;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.model.dto.ImageTransformData;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.generator.impl.AbstractClickImageCaptchaGenerator;
import cloud.tianai.captcha.interceptor.CaptchaInterceptor;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

public class StandardWordClickImageCaptchaGenerator
extends AbstractClickImageCaptchaGenerator {
    protected List<FontWrapper> fonts = new ArrayList<FontWrapper>();
    protected Integer clickImgWidth = 100;
    protected Integer clickImgHeight = 100;
    protected int tipImageInterferenceLineNum = 2;
    protected int tipImageInterferencePointNum = 5;
    protected Integer checkClickCount = 4;
    protected Integer interferenceCount = 2;

    public StandardWordClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public StandardWordClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
    }

    public StandardWordClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform, CaptchaInterceptor interceptor) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
        this.setInterceptor(interceptor);
    }

    public StandardWordClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform, CaptchaInterceptor interceptor, List<FontWrapper> fonts) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
        this.setInterceptor(interceptor);
        this.fonts = fonts;
    }

    @Override
    protected List<Resource> randomGetClickImgTips(GenerateParam param) {
        int tipSize = this.interferenceCount + this.checkClickCount;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ArrayList<Resource> tipList = new ArrayList<Resource>(tipSize);
        for (int i = 0; i < tipSize; ++i) {
            String randomWord = FontUtils.getRandomChar(random);
            tipList.add(new Resource(null, randomWord));
        }
        return tipList;
    }

    @Override
    protected void doInit() {
        if (CollectionUtils.isEmpty(this.fonts)) {
            throw new ImageCaptchaException("\u521d\u59cb\u5316\u6587\u5b57\u70b9\u9009\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u8bf7\u8bbe\u7f6e\u5b57\u4f53\u5305\u540e\u518d\u8c03\u7528init()");
        }
    }

    public AbstractClickImageCaptchaGenerator.ImgWrapper genTipImage(List<ClickImageCheckDefinition> imageCheckDefinitions) {
        FontWrapper fontWrapper = this.fonts.get(this.randomInt(this.fonts.size()));
        Font font = fontWrapper.getFont();
        float currentFontTopCoef = fontWrapper.getCurrentFontTopCoef();
        String tips = imageCheckDefinitions.stream().map(c -> c.getTip().getData()).collect(Collectors.joining());
        int fontWidth = tips.length() * font.getSize();
        int width = fontWidth + 6;
        int height = font.getSize() + 6;
        float left = (float)(width - fontWidth) / 2.0f;
        float top = 3.0f + (float)font.getSize() - currentFontTopCoef;
        BufferedImage bufferedImage = CaptchaImageUtils.genSimpleImgCaptcha(tips, font, width, height, left, top, this.tipImageInterferenceLineNum, this.tipImageInterferencePointNum);
        return new AbstractClickImageCaptchaGenerator.ImgWrapper(bufferedImage, new Resource(null, tips), null);
    }

    @Override
    public AbstractClickImageCaptchaGenerator.ImgWrapper getClickImg(Resource tip) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Color randomColor = CaptchaImageUtils.getRandomColor(random);
        int randomDeg = this.randomInt(0, 85);
        FontWrapper fontWrapper = this.fonts.get(this.randomInt(this.fonts.size()));
        Font font = fontWrapper.getFont();
        float currentFontTopCoef = fontWrapper.getCurrentFontTopCoef();
        BufferedImage fontImage = CaptchaImageUtils.drawWordImg(randomColor, tip.getData(), font, currentFontTopCoef, this.clickImgWidth, this.clickImgHeight, randomDeg);
        return new AbstractClickImageCaptchaGenerator.ImgWrapper(fontImage, tip, randomColor);
    }

    @Override
    protected List<ClickImageCheckDefinition> filterAndSortClickImageCheckDefinition(List<ClickImageCheckDefinition> allCheckDefinitionList) {
        Collections.shuffle(allCheckDefinitionList);
        ArrayList<ClickImageCheckDefinition> checkClickImageCheckDefinitionList = new ArrayList<ClickImageCheckDefinition>(this.checkClickCount);
        for (int i = 0; i < this.checkClickCount; ++i) {
            ClickImageCheckDefinition clickImageCheckDefinition = allCheckDefinitionList.get(i);
            checkClickImageCheckDefinitionList.add(clickImageCheckDefinition);
        }
        return checkClickImageCheckDefinitionList;
    }

    @Override
    public ImageCaptchaInfo doWrapImageCaptchaInfo(CaptchaExchange captchaExchange) {
        List checkClickImageCheckDefinitionList = (List)captchaExchange.getTransferData();
        BufferedImage bgImage = captchaExchange.getBackgroundImage();
        GenerateParam param = captchaExchange.getParam();
        Resource resourceImage = captchaExchange.getResourceImage();
        CustomData data = captchaExchange.getCustomData();
        BufferedImage tipImage = this.genTipImage(checkClickImageCheckDefinitionList).getImage();
        ImageTransformData transform = this.getImageTransform().transform(param, bgImage, tipImage, resourceImage, checkClickImageCheckDefinitionList, data);
        ImageCaptchaInfo clickImageCaptchaInfo = new ImageCaptchaInfo();
        clickImageCaptchaInfo.setBackgroundImage(transform.getBackgroundImageUrl());
        clickImageCaptchaInfo.setBackgroundImageTag(resourceImage.getTag());
        clickImageCaptchaInfo.setTemplateImage(transform.getTemplateImageUrl());
        clickImageCaptchaInfo.setBackgroundImageWidth(bgImage.getWidth());
        clickImageCaptchaInfo.setBackgroundImageHeight(bgImage.getHeight());
        clickImageCaptchaInfo.setTemplateImageWidth(tipImage.getWidth());
        clickImageCaptchaInfo.setTemplateImageHeight(tipImage.getHeight());
        clickImageCaptchaInfo.setRandomX(null);
        clickImageCaptchaInfo.setTolerant(null);
        clickImageCaptchaInfo.setType("WORD_IMAGE_CLICK");
        data.setExpand(checkClickImageCheckDefinitionList);
        return clickImageCaptchaInfo;
    }

    public List<FontWrapper> getFonts() {
        return this.fonts;
    }

    public void setFonts(List<FontWrapper> fonts) {
        this.fonts = fonts;
    }

    public Integer getClickImgWidth() {
        return this.clickImgWidth;
    }

    public void setClickImgWidth(Integer clickImgWidth) {
        this.clickImgWidth = clickImgWidth;
    }

    public Integer getClickImgHeight() {
        return this.clickImgHeight;
    }

    public void setClickImgHeight(Integer clickImgHeight) {
        this.clickImgHeight = clickImgHeight;
    }

    public int getTipImageInterferenceLineNum() {
        return this.tipImageInterferenceLineNum;
    }

    public void setTipImageInterferenceLineNum(int tipImageInterferenceLineNum) {
        this.tipImageInterferenceLineNum = tipImageInterferenceLineNum;
    }

    public int getTipImageInterferencePointNum() {
        return this.tipImageInterferencePointNum;
    }

    public void setTipImageInterferencePointNum(int tipImageInterferencePointNum) {
        this.tipImageInterferencePointNum = tipImageInterferencePointNum;
    }

    public Integer getCheckClickCount() {
        return this.checkClickCount;
    }

    public void setCheckClickCount(Integer checkClickCount) {
        this.checkClickCount = checkClickCount;
    }

    public Integer getInterferenceCount() {
        return this.interferenceCount;
    }

    public void setInterferenceCount(Integer interferenceCount) {
        this.interferenceCount = interferenceCount;
    }
}

