/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.interceptor;

import cloud.tianai.captcha.common.AnyMap;
import cloud.tianai.captcha.interceptor.CaptchaInterceptor;

public class Context {
    private String name;
    private Context parent;
    private Integer current;
    private Integer count;
    private CaptchaInterceptor group;
    private Object preReturnData;
    private AnyMap data = new AnyMap();

    public Context(String name, Context parent, Integer current, Integer count, CaptchaInterceptor group) {
        this.name = name;
        this.parent = parent;
        this.current = current;
        this.count = count;
        this.group = group;
    }

    public Object getPreReturnData() {
        Object returnData = this.preReturnData;
        if (returnData == null && this.parent != null) {
            returnData = this.parent.getPreReturnData();
        }
        return returnData;
    }

    public void putCurrentData(String key, Object value) {
        this.data.put(key, value);
    }

    public <T> T getCurrentData(String key, Class<T> type) {
        return this.convert(this.data.get(key), type);
    }

    public void putData(String key, Object value) {
        this.putCurrentData(key, value);
        if (this.parent != null) {
            this.parent.putData(key, value);
        }
    }

    public <T> T getData(String key, Class<T> type) {
        T result = this.getCurrentData(key, type);
        if (result == null && this.parent != null) {
            result = this.parent.getData(key, type);
        }
        return result;
    }

    private <T> T convert(Object data, Class<T> clazz) {
        if (data == null || clazz == null) {
            return null;
        }
        return (T)data;
    }

    public Integer next() {
        Integer n = this.current;
        Integer n2 = this.current = Integer.valueOf(this.current + 1);
        return this.current;
    }

    public Integer end() {
        this.current = this.count;
        return this.count;
    }

    public Boolean isEnd() {
        return this.current >= this.count;
    }

    public Boolean isStart() {
        return this.current < 0;
    }

    public void allEnd() {
        Context context = this.parent;
        if (context != null) {
            context.allEnd();
        }
        this.end();
    }

    public String getName() {
        return this.name;
    }

    public Context getParent() {
        return this.parent;
    }

    public Integer getCurrent() {
        return this.current;
    }

    public Integer getCount() {
        return this.count;
    }

    public CaptchaInterceptor getGroup() {
        return this.group;
    }

    public AnyMap getData() {
        return this.data;
    }

    public void setParent(Context parent) {
        this.parent = parent;
    }

    public void setPreReturnData(Object preReturnData) {
        this.preReturnData = preReturnData;
    }
}

