/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource.impl;

import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceProvider;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import cloud.tianai.captcha.resource.impl.LocalMemoryResourceStore;
import cloud.tianai.captcha.resource.impl.provider.ClassPathResourceProvider;
import cloud.tianai.captcha.resource.impl.provider.FileResourceProvider;
import cloud.tianai.captcha.resource.impl.provider.URLResourceProvider;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultImageCaptchaResourceManager
implements ImageCaptchaResourceManager {
    private ResourceStore resourceStore;
    private final List<ResourceProvider> resourceProviderList = new ArrayList<ResourceProvider>(8);

    public DefaultImageCaptchaResourceManager() {
        this.init();
    }

    public DefaultImageCaptchaResourceManager(ResourceStore resourceStore) {
        this.resourceStore = resourceStore;
        this.init();
    }

    private void init() {
        if (this.resourceStore == null) {
            this.resourceStore = new LocalMemoryResourceStore();
        }
        this.registerResourceProvider(new URLResourceProvider());
        this.registerResourceProvider(new ClassPathResourceProvider());
        this.registerResourceProvider(new FileResourceProvider());
    }

    @Override
    public ResourceMap randomGetTemplate(String type, String tag) {
        ResourceMap resourceMap = this.resourceStore.randomGetTemplateByTypeAndTag(type, tag);
        if (resourceMap == null) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u6a21\u677f\u9519\u8bef\uff0cstore\u4e2d\u6a21\u677f\u4e3a\u7a7a, type:" + type);
        }
        return resourceMap;
    }

    @Override
    public Resource randomGetResource(String type, String tag) {
        Resource resource = this.resourceStore.randomGetResourceByTypeAndTag(type, tag);
        if (resource == null) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u8d44\u6e90\u9519\u8bef\uff0cstore\u4e2d\u8d44\u6e90\u4e3a\u7a7a, type:" + type);
        }
        return resource;
    }

    @Override
    public InputStream getResourceInputStream(Resource resource) {
        for (ResourceProvider resourceProvider : this.resourceProviderList) {
            if (!resourceProvider.supported(resource.getType())) continue;
            InputStream resourceInputStream = resourceProvider.getResourceInputStream(resource);
            if (resourceInputStream == null) {
                throw new IllegalArgumentException("\u6ed1\u5757\u9a8c\u8bc1\u7801 ResourceProvider \u8bfb\u5230\u7684\u56fe\u7247\u8d44\u6e90\u4e3a\u7a7a,providerName=[" + resourceProvider.getName() + "], resource=[" + resource + "]");
            }
            return resourceInputStream;
        }
        throw new IllegalStateException("\u6ca1\u6709\u627e\u5230Resource [" + resource.getType() + "]\u5bf9\u5e94\u7684\u8d44\u6e90\u63d0\u4f9b\u8005");
    }

    @Override
    public List<ResourceProvider> listResourceProviders() {
        return Collections.unmodifiableList(this.resourceProviderList);
    }

    @Override
    public void registerResourceProvider(ResourceProvider resourceProvider) {
        this.deleteResourceProviderByName(resourceProvider.getName());
        this.resourceProviderList.add(resourceProvider);
    }

    @Override
    public boolean deleteResourceProviderByName(String name) {
        return this.resourceProviderList.removeIf(r -> r.getName().equals(name));
    }

    @Override
    public void setResourceStore(ResourceStore resourceStore) {
        this.resourceStore = resourceStore;
    }

    @Override
    public ResourceStore getResourceStore() {
        return this.resourceStore;
    }
}

