/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.interceptor.impl;

import cloud.tianai.captcha.common.AnyMap;
import cloud.tianai.captcha.common.response.ApiResponse;
import cloud.tianai.captcha.common.response.CodeDefinition;
import cloud.tianai.captcha.common.util.CaptchaTypeClassifier;
import cloud.tianai.captcha.interceptor.CaptchaInterceptor;
import cloud.tianai.captcha.interceptor.Context;
import cloud.tianai.captcha.validator.common.model.dto.ImageCaptchaTrack;
import cloud.tianai.captcha.validator.common.model.dto.MatchParam;
import java.util.List;

public class BasicTrackCaptchaInterceptor
implements CaptchaInterceptor {
    public static final CodeDefinition DEFINITION = new CodeDefinition(50001, "basic track check fail");

    @Override
    public String getName() {
        return "basic_track_check";
    }

    @Override
    public ApiResponse<?> afterValid(Context context, String type, MatchParam matchData, AnyMap validData, ApiResponse<?> basicValid) {
        boolean check;
        if (!basicValid.isSuccess()) {
            return context.getGroup().afterValid(context, type, matchData, validData, basicValid);
        }
        if (!CaptchaTypeClassifier.isSliderCaptcha(type)) {
            return ApiResponse.ofSuccess();
        }
        ImageCaptchaTrack imageCaptchaTrack = matchData.getTrack();
        long startSlidingTime = imageCaptchaTrack.getStartTime();
        long endSlidingTime = imageCaptchaTrack.getStopTime();
        Integer bgImageWidth = imageCaptchaTrack.getBgImageWidth();
        List<ImageCaptchaTrack.Track> trackList = imageCaptchaTrack.getTrackList();
        if (startSlidingTime + 300L > endSlidingTime) {
            context.end();
            return ApiResponse.ofMessage(DEFINITION);
        }
        if (trackList.size() < 10 || trackList.size() > bgImageWidth * 5) {
            context.end();
            return ApiResponse.ofMessage(DEFINITION);
        }
        ImageCaptchaTrack.Track firstTrack = trackList.get(0);
        if (firstTrack.getX().floatValue() > 10.0f || firstTrack.getX().floatValue() < -10.0f || firstTrack.getY().floatValue() > 10.0f || firstTrack.getY().floatValue() < -10.0f) {
            context.end();
            return ApiResponse.ofMessage(DEFINITION);
        }
        int check4 = 0;
        int check7 = 0;
        for (int i = 1; i < trackList.size(); ++i) {
            ImageCaptchaTrack.Track track = trackList.get(i);
            float x = track.getX().floatValue();
            float y = track.getY().floatValue();
            if (firstTrack.getY().floatValue() == y) {
                ++check4;
            }
            if (x >= (float)bgImageWidth.intValue()) {
                ++check7;
            }
            ImageCaptchaTrack.Track preTrack = trackList.get(i - 1);
            if (!(track.getX().floatValue() - preTrack.getX().floatValue() > 50.0f) && !(track.getY().floatValue() - preTrack.getY().floatValue() > 50.0f)) continue;
            context.end();
            return ApiResponse.ofMessage(DEFINITION);
        }
        if (check4 == trackList.size() || check7 > 200) {
            context.end();
            return ApiResponse.ofMessage(DEFINITION);
        }
        int splitPos = (int)((double)trackList.size() * 0.7);
        ImageCaptchaTrack.Track splitPostTrack = trackList.get(splitPos - 1);
        ImageCaptchaTrack.Track lastTrack = trackList.get(trackList.size() - 1);
        ImageCaptchaTrack.Track stepOneFirstTrack = trackList.get(0);
        ImageCaptchaTrack.Track stepOneTwoTrack = trackList.get(splitPos);
        float posTime = splitPostTrack.getT().floatValue() - stepOneFirstTrack.getT().floatValue();
        double startAvgPosTime = posTime / (float)splitPos;
        double endAvgPosTime = (lastTrack.getT().floatValue() - stepOneTwoTrack.getT().floatValue()) / (float)(trackList.size() - splitPos);
        boolean bl = check = endAvgPosTime > startAvgPosTime;
        if (check) {
            return ApiResponse.ofSuccess();
        }
        context.end();
        return ApiResponse.ofMessage(DEFINITION);
    }
}

