/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.system;

import cn.hutool.core.util.ReUtil;
import cn.hutool.system.SystemUtil;
import java.io.Serializable;

public class JavaInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String JAVA_VERSION = SystemUtil.get("java.version", false);
    private final float JAVA_VERSION_FLOAT = this.getJavaVersionAsFloat();
    private final int JAVA_VERSION_INT = this.getJavaVersionAsInt();
    private final String JAVA_VENDOR = SystemUtil.get("java.vendor", false);
    private final String JAVA_VENDOR_URL = SystemUtil.get("java.vendor.url", false);
    private final boolean IS_JAVA_1_1 = this.getJavaVersionMatches("1.1");
    private final boolean IS_JAVA_1_2 = this.getJavaVersionMatches("1.2");
    private final boolean IS_JAVA_1_3 = this.getJavaVersionMatches("1.3");
    private final boolean IS_JAVA_1_4 = this.getJavaVersionMatches("1.4");
    private final boolean IS_JAVA_1_5 = this.getJavaVersionMatches("1.5");
    private final boolean IS_JAVA_1_6 = this.getJavaVersionMatches("1.6");
    private final boolean IS_JAVA_1_7 = this.getJavaVersionMatches("1.7");
    private final boolean IS_JAVA_1_8 = this.getJavaVersionMatches("1.8");
    private final boolean IS_JAVA_9 = this.getJavaVersionMatches("9");
    private final boolean IS_JAVA_10 = this.getJavaVersionMatches("10");
    private final boolean IS_JAVA_11 = this.getJavaVersionMatches("11");
    private final boolean IS_JAVA_12 = this.getJavaVersionMatches("12");

    public final String getVersion() {
        return this.JAVA_VERSION;
    }

    public final float getVersionFloat() {
        return this.JAVA_VERSION_FLOAT;
    }

    public final int getVersionInt() {
        return this.JAVA_VERSION_INT;
    }

    private final float getJavaVersionAsFloat() {
        if (this.JAVA_VERSION == null) {
            return 0.0f;
        }
        String str = this.JAVA_VERSION;
        str = ReUtil.get((String)"^[0-9]{1,2}(\\.[0-9]{1,2})?", (CharSequence)str, (int)0);
        return Float.parseFloat(str);
    }

    private final int getJavaVersionAsInt() {
        if (this.JAVA_VERSION == null) {
            return 0;
        }
        String java_version = this.JAVA_VERSION;
        java_version = ReUtil.get((String)"^[0-9]{1,2}(\\.[0-9]{1,2}){0,2}", (CharSequence)java_version, (int)0);
        String[] split = java_version.split("\\.");
        String result = "";
        for (int i = 0; i < split.length; ++i) {
            result = result + split[i];
        }
        if (split[0].length() > 1 && result.length() != 4) {
            result = result + "0000";
            result = result.substring(0, 4);
        }
        return Integer.parseInt(result);
    }

    public final String getVendor() {
        return this.JAVA_VENDOR;
    }

    public final String getVendorURL() {
        return this.JAVA_VENDOR_URL;
    }

    public final boolean isJava1_1() {
        return this.IS_JAVA_1_1;
    }

    public final boolean isJava1_2() {
        return this.IS_JAVA_1_2;
    }

    public final boolean isJava1_3() {
        return this.IS_JAVA_1_3;
    }

    public final boolean isJava1_4() {
        return this.IS_JAVA_1_4;
    }

    public final boolean isJava1_5() {
        return this.IS_JAVA_1_5;
    }

    public final boolean isJava1_6() {
        return this.IS_JAVA_1_6;
    }

    public final boolean isJava1_7() {
        return this.IS_JAVA_1_7;
    }

    public final boolean isJava1_8() {
        return this.IS_JAVA_1_8;
    }

    public final boolean isJava9() {
        return this.IS_JAVA_9;
    }

    public final boolean isJava10() {
        return this.IS_JAVA_10;
    }

    public final boolean isJava11() {
        return this.IS_JAVA_11;
    }

    public final boolean isJava12() {
        return this.IS_JAVA_12;
    }

    private final boolean getJavaVersionMatches(String versionPrefix) {
        if (this.JAVA_VERSION == null) {
            return false;
        }
        return this.JAVA_VERSION.startsWith(versionPrefix);
    }

    public final boolean isJavaVersionAtLeast(float requiredVersion) {
        return this.getVersionFloat() >= requiredVersion;
    }

    public final boolean isJavaVersionAtLeast(int requiredVersion) {
        return this.getVersionInt() >= requiredVersion;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        SystemUtil.append(builder, "Java Version:    ", this.getVersion());
        SystemUtil.append(builder, "Java Vendor:     ", this.getVendor());
        SystemUtil.append(builder, "Java Vendor URL: ", this.getVendorURL());
        return builder.toString();
    }
}

