/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FrequentItemSetsField
implements JsonpSerializable {
    private final String field;
    private final List<String> exclude;
    private final List<String> include;
    public static final JsonpDeserializer<FrequentItemSetsField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FrequentItemSetsField::setupFrequentItemSetsFieldDeserializer);

    private FrequentItemSetsField(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.exclude = ApiTypeHelper.unmodifiable(builder.exclude);
        this.include = ApiTypeHelper.unmodifiable(builder.include);
    }

    public static FrequentItemSetsField of(Function<Builder, ObjectBuilder<FrequentItemSetsField>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public final List<String> exclude() {
        return this.exclude;
    }

    public final List<String> include() {
        return this.include;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.exclude)) {
            generator.writeKey("exclude");
            generator.writeStartArray();
            for (String item0 : this.exclude) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.include)) {
            generator.writeKey("include");
            generator.writeStartArray();
            for (String item0 : this.include) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFrequentItemSetsFieldDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::exclude, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "exclude");
        op.add(Builder::include, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "include");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FrequentItemSetsField> {
        private String field;
        @Nullable
        private List<String> exclude;
        @Nullable
        private List<String> include;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder exclude(List<String> list) {
            this.exclude = Builder._listAddAll(this.exclude, list);
            return this;
        }

        public final Builder exclude(String value, String ... values) {
            this.exclude = Builder._listAdd(this.exclude, value, values);
            return this;
        }

        public final Builder include(List<String> list) {
            this.include = Builder._listAddAll(this.include, list);
            return this;
        }

        public final Builder include(String value, String ... values) {
            this.include = Builder._listAdd(this.include, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FrequentItemSetsField build() {
            this._checkSingleUse();
            return new FrequentItemSetsField(this);
        }
    }
}

