/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataStreams
extends Base {
    private final long dataStreams;
    private final long indicesCount;
    public static final JsonpDeserializer<DataStreams> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreams::setupDataStreamsDeserializer);

    private DataStreams(Builder builder) {
        super(builder);
        this.dataStreams = ApiTypeHelper.requireNonNull(builder.dataStreams, this, "dataStreams");
        this.indicesCount = ApiTypeHelper.requireNonNull(builder.indicesCount, this, "indicesCount");
    }

    public static DataStreams of(Function<Builder, ObjectBuilder<DataStreams>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long dataStreams() {
        return this.dataStreams;
    }

    public final long indicesCount() {
        return this.indicesCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("data_streams");
        generator.write(this.dataStreams);
        generator.writeKey("indices_count");
        generator.write(this.indicesCount);
    }

    protected static void setupDataStreamsDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::dataStreams, JsonpDeserializer.longDeserializer(), "data_streams");
        op.add(Builder::indicesCount, JsonpDeserializer.longDeserializer(), "indices_count");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<DataStreams> {
        private Long dataStreams;
        private Long indicesCount;

        public final Builder dataStreams(long value) {
            this.dataStreams = value;
            return this;
        }

        public final Builder indicesCount(long value) {
            this.indicesCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreams build() {
            this._checkSingleUse();
            return new DataStreams(this);
        }
    }
}

