/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.StoredScript;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.PutScriptResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutScriptRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String context;
    private final String id;
    @Nullable
    private final Time masterTimeout;
    private final StoredScript script;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutScriptRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutScriptRequest::setupPutScriptRequestDeserializer);
    public static final Endpoint<PutScriptRequest, PutScriptResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutScriptRequest, PutScriptResponse>("es/put_script", request -> "PUT", request -> {
        boolean _context = true;
        int _id = 2;
        int propsSet = 0;
        if (request.context() != null) {
            propsSet |= 1;
        }
        if ((propsSet |= 2) == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_scripts");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_scripts");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.context, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _context = true;
        int _id = 2;
        int propsSet = 0;
        if (request.context() != null) {
            propsSet |= 1;
        }
        if ((propsSet |= 2) == 2) {
            params.put("id", request.id);
        }
        if (propsSet == 3) {
            params.put("id", request.id);
            params.put("context", request.context);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutScriptResponse._DESERIALIZER);

    private PutScriptRequest(Builder builder) {
        this.context = builder.context;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.masterTimeout = builder.masterTimeout;
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
        this.timeout = builder.timeout;
    }

    public static PutScriptRequest of(Function<Builder, ObjectBuilder<PutScriptRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String context() {
        return this.context;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final StoredScript script() {
        return this.script;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
    }

    protected static void setupPutScriptRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::script, StoredScript._DESERIALIZER, "script");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutScriptRequest> {
        @Nullable
        private String context;
        private String id;
        @Nullable
        private Time masterTimeout;
        private StoredScript script;
        @Nullable
        private Time timeout;

        public final Builder context(@Nullable String value) {
            this.context = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder script(StoredScript value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<StoredScript.Builder, ObjectBuilder<StoredScript>> fn) {
            return this.script(fn.apply(new StoredScript.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutScriptRequest build() {
            this._checkSingleUse();
            return new PutScriptRequest(this);
        }
    }
}

