/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CacheStats
implements JsonpSerializable {
    private final String nodeId;
    private final int count;
    private final int hits;
    private final long hitsTimeInMillis;
    private final int misses;
    private final long missesTimeInMillis;
    private final int evictions;
    public static final JsonpDeserializer<CacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CacheStats::setupCacheStatsDeserializer);

    private CacheStats(Builder builder) {
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.hits = ApiTypeHelper.requireNonNull(builder.hits, this, "hits");
        this.hitsTimeInMillis = ApiTypeHelper.requireNonNull(builder.hitsTimeInMillis, this, "hitsTimeInMillis");
        this.misses = ApiTypeHelper.requireNonNull(builder.misses, this, "misses");
        this.missesTimeInMillis = ApiTypeHelper.requireNonNull(builder.missesTimeInMillis, this, "missesTimeInMillis");
        this.evictions = ApiTypeHelper.requireNonNull(builder.evictions, this, "evictions");
    }

    public static CacheStats of(Function<Builder, ObjectBuilder<CacheStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final int count() {
        return this.count;
    }

    public final int hits() {
        return this.hits;
    }

    public final long hitsTimeInMillis() {
        return this.hitsTimeInMillis;
    }

    public final int misses() {
        return this.misses;
    }

    public final long missesTimeInMillis() {
        return this.missesTimeInMillis;
    }

    public final int evictions() {
        return this.evictions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("hits");
        generator.write(this.hits);
        generator.writeKey("hits_time_in_millis");
        generator.write(this.hitsTimeInMillis);
        generator.writeKey("misses");
        generator.write(this.misses);
        generator.writeKey("misses_time_in_millis");
        generator.write(this.missesTimeInMillis);
        generator.writeKey("evictions");
        generator.write(this.evictions);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCacheStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::hits, JsonpDeserializer.integerDeserializer(), "hits");
        op.add(Builder::hitsTimeInMillis, JsonpDeserializer.longDeserializer(), "hits_time_in_millis");
        op.add(Builder::misses, JsonpDeserializer.integerDeserializer(), "misses");
        op.add(Builder::missesTimeInMillis, JsonpDeserializer.longDeserializer(), "misses_time_in_millis");
        op.add(Builder::evictions, JsonpDeserializer.integerDeserializer(), "evictions");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CacheStats> {
        private String nodeId;
        private Integer count;
        private Integer hits;
        private Long hitsTimeInMillis;
        private Integer misses;
        private Long missesTimeInMillis;
        private Integer evictions;

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder hits(int value) {
            this.hits = value;
            return this;
        }

        public final Builder hitsTimeInMillis(long value) {
            this.hitsTimeInMillis = value;
            return this;
        }

        public final Builder misses(int value) {
            this.misses = value;
            return this;
        }

        public final Builder missesTimeInMillis(long value) {
            this.missesTimeInMillis = value;
            return this;
        }

        public final Builder evictions(int value) {
            this.evictions = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CacheStats build() {
            this._checkSingleUse();
            return new CacheStats(this);
        }
    }
}

