/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.esql;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.esql.query.EsqlFormat;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.BinaryEndpoint;
import co.elastic.clients.transport.endpoints.BinaryResponse;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean columnar;
    @Nullable
    private final String delimiter;
    @Nullable
    private final Query filter;
    @Nullable
    private final EsqlFormat format;
    @Nullable
    private final String locale;
    private final List<FieldValue> params;
    private final String query;
    public static final JsonpDeserializer<QueryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRequest::setupQueryRequestDeserializer);
    public static final Endpoint<QueryRequest, BinaryResponse, ErrorResponse> _ENDPOINT = new BinaryEndpoint<QueryRequest>("es/esql.query", request -> "POST", request -> "/_query", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.delimiter != null) {
            params.put("delimiter", request.delimiter);
        }
        if (request.format != null) {
            params.put("format", request.format.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    private QueryRequest(Builder builder) {
        this.columnar = builder.columnar;
        this.delimiter = builder.delimiter;
        this.filter = builder.filter;
        this.format = builder.format;
        this.locale = builder.locale;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static QueryRequest of(Function<Builder, ObjectBuilder<QueryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean columnar() {
        return this.columnar;
    }

    @Nullable
    public final String delimiter() {
        return this.delimiter;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Nullable
    public final EsqlFormat format() {
        return this.format;
    }

    @Nullable
    public final String locale() {
        return this.locale;
    }

    public final List<FieldValue> params() {
        return this.params;
    }

    public final String query() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.columnar != null) {
            generator.writeKey("columnar");
            generator.write(this.columnar.booleanValue());
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.locale != null) {
            generator.writeKey("locale");
            generator.write(this.locale);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartArray();
            for (FieldValue item0 : this.params) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("query");
        generator.write(this.query);
    }

    protected static void setupQueryRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::columnar, JsonpDeserializer.booleanDeserializer(), "columnar");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale");
        op.add(Builder::params, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "params");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<QueryRequest> {
        @Nullable
        private Boolean columnar;
        @Nullable
        private String delimiter;
        @Nullable
        private Query filter;
        @Nullable
        private EsqlFormat format;
        @Nullable
        private String locale;
        @Nullable
        private List<FieldValue> params;
        private String query;

        public final Builder columnar(@Nullable Boolean value) {
            this.columnar = value;
            return this;
        }

        public final Builder delimiter(@Nullable String value) {
            this.delimiter = value;
            return this;
        }

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final Builder format(@Nullable EsqlFormat value) {
            this.format = value;
            return this;
        }

        public final Builder locale(@Nullable String value) {
            this.locale = value;
            return this;
        }

        public final Builder params(List<FieldValue> list) {
            this.params = Builder._listAddAll(this.params, list);
            return this;
        }

        public final Builder params(FieldValue value, FieldValue ... values) {
            this.params = Builder._listAdd(this.params, value, values);
            return this;
        }

        public final Builder params(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.params(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRequest build() {
            this._checkSingleUse();
            return new QueryRequest(this);
        }
    }
}

